package jp.gopay.sdk.builders;

import jp.gopay.sdk.models.response.GoPayResponse;
import retrofit2.Call;
import retrofit2.Retrofit;

import java.lang.reflect.ParameterizedType;

public abstract class RetrofitRequestBuilder<E extends GoPayResponse, R>
        implements RequestBuilder<E,Request<E>> {

    private Class<R> resourceClass;
    private Retrofit retrofit;

    public RetrofitRequestBuilder(Retrofit retrofit) {
        this.retrofit = retrofit;

        this.resourceClass = (Class<R>) ((ParameterizedType) getClass()
                .getGenericSuperclass()).getActualTypeArguments()[1];
    }

    Call<E> createCall() {
        R resource = retrofit.create(resourceClass);
        return getRequest(resource);
    }

    protected abstract Call<E> getRequest(R resource);

    @Override
    public Request<E> build() {
        return new RetrofitRequestCaller<>(retrofit, createCall());
    }
    
}
