package jp.gopay.sdk.builders;

import jp.gopay.sdk.models.common.BaseId;
import jp.gopay.sdk.models.response.PaginatedList;
import jp.gopay.sdk.models.response.PaginatedListIterable;
import jp.gopay.sdk.models.response.PaginatedListIterator;
import jp.gopay.sdk.models.response.SimpleModel;
import jp.gopay.sdk.types.CursorDirection;
import jp.gopay.sdk.utils.Backoff;
import jp.gopay.sdk.utils.ExponentialBackoff;
import retrofit2.Retrofit;

/**
 * Created by nasu on 2017/06/29.
 */
public abstract class RetrofitRequestBuilderPaginated<E extends SimpleModel, R, T , C extends BaseId>
        extends RetrofitRequestBuilder<PaginatedList<E>, R>
        implements Paginator<E, T, C>{

    private Integer limit;
    private CursorDirection cursorDirection;
    private C cursor;

    public RetrofitRequestBuilderPaginated(Retrofit retrofit) {
        super(retrofit);
    }

    @Override
    public T setLimit(Integer limit) {
        this.limit = limit;
        return (T) this;
    }

    @Override
    public T setCursorDirection(CursorDirection cursorDirection) {
        this.cursorDirection = cursorDirection;
        return (T) this;
    }

    @Override
    public T setCursor(C cursor) {
        this.cursor = cursor;
        return (T) this;
    }

    public Integer getLimit() {
        return limit;
    }

    public CursorDirection getCursorDirection() {
        return cursorDirection;
    }

    public C getCursor() {
        return cursor;
    }

    public PaginatedListIterable<E> asIterable() {
        PaginatedListIterator<E> list = new PaginatedListIterator<>(this, 900_000L, createBackoff());
        return new PaginatedListIterable<>(list);
    }

    public PaginatedListIterable<E> asIterable(long timeout) {
        PaginatedListIterator<E> list = new PaginatedListIterator<>(this, timeout, createBackoff());
        return new PaginatedListIterable<>(list);
    }

    public PaginatedListIterable<E> asIterable(long timeout, Backoff backoff) {
        PaginatedListIterator<E> list = new PaginatedListIterator<>(this, timeout, backoff);
        return new PaginatedListIterable<>(list);
    }

    private Backoff createBackoff() {
        return new ExponentialBackoff(1_000L, 30_000L, 1.1, 0.5);
    }
}
