package jp.gopay.sdk.builders.authentication;

import jp.gopay.sdk.builders.RetrofitRequestBuilder;
import jp.gopay.sdk.models.common.Void;
import jp.gopay.sdk.models.response.authentication.LoginTokenInfo;
import retrofit2.Retrofit;

public abstract class AbstractAuthenticationBuilders {

    public static abstract class AbstractLoginRequestBuilder<B extends AbstractLoginRequestBuilder, R, M extends LoginTokenInfo>
            extends RetrofitRequestBuilder<M, R> {

        protected String email;
        protected String password;

        protected String getEmail() {
            return email;
        }

        protected String getPassword() {
            return password;
        }

        public AbstractLoginRequestBuilder(Retrofit retrofit, String email, String password) {
            super(retrofit);
            this.email = email;
            this.password = password;
        }

    }

    public static abstract class AbstractLogoutRequestBuilder<B extends AbstractLogoutRequestBuilder, R>
            extends RetrofitRequestBuilder<Void, R> {

        public AbstractLogoutRequestBuilder(Retrofit retrofit) {
            super(retrofit);
        }

    }

}
