package jp.gopay.sdk.builders.authentication;

import jp.gopay.sdk.models.common.Void;
import jp.gopay.sdk.models.request.authentication.AuthenticationRequestData;
import jp.gopay.sdk.models.response.authentication.LoginTokenInfo;
import jp.gopay.sdk.resources.AuthenticationResource;
import retrofit2.Call;
import retrofit2.Retrofit;

import static jp.gopay.sdk.builders.authentication.AbstractAuthenticationBuilders.AbstractLoginRequestBuilder;
import static jp.gopay.sdk.builders.authentication.AbstractAuthenticationBuilders.AbstractLogoutRequestBuilder;

public abstract class AuthenticationBuilders {

    public static class LoginRequestBuilder extends AbstractLoginRequestBuilder<LoginRequestBuilder, AuthenticationResource, LoginTokenInfo>{
        public LoginRequestBuilder(Retrofit retrofit, String email, String password) {
            super(retrofit, email, password);
        }

        @Override
        protected Call<LoginTokenInfo> getRequest(AuthenticationResource resource) {
            return resource.getLoginToken(new AuthenticationRequestData(email, password));
        }
    }

    public static class LogoutRequestBuilder extends AbstractLogoutRequestBuilder<LogoutRequestBuilder, AuthenticationResource>{
        public LogoutRequestBuilder(Retrofit retrofit) {
            super(retrofit);
        }

        @Override
        protected Call<Void> getRequest(AuthenticationResource resource) {
            return resource.deleteAuthToken();
        }
    }


}
