package jp.gopay.sdk.builders.bankaccount;

import jp.gopay.sdk.builders.IdempotentRetrofitRequestBuilder;
import jp.gopay.sdk.builders.RetrofitRequestBuilder;
import jp.gopay.sdk.builders.RetrofitRequestBuilderPaginated;
import jp.gopay.sdk.models.common.BankAccountId;
import jp.gopay.sdk.models.common.Void;
import jp.gopay.sdk.models.common.bankaccounts.BaseBankAccount;
import jp.gopay.sdk.models.response.bankaccount.BankAccount;
import retrofit2.Retrofit;

public abstract class AbstractBankAccountsBuilders {

    public static abstract class AbstractCreateBankAccountRequestBuilder<B extends AbstractCreateBankAccountRequestBuilder, R, M extends BankAccount>
            extends IdempotentRetrofitRequestBuilder<M, R, B> {
        protected BaseBankAccount bankAccount;

        public BaseBankAccount getBankAccount() {
            return bankAccount;
        }

        public AbstractCreateBankAccountRequestBuilder(Retrofit retrofit, BaseBankAccount bankAccount) {
            super(retrofit);
            this.bankAccount = bankAccount;
        }

    }


    public static abstract class AbstractDeleteBankAccountRequestBuilder<B extends AbstractDeleteBankAccountRequestBuilder, R>
            extends RetrofitRequestBuilder<Void, R> {
        protected BankAccountId bankAccountId;

        protected BankAccountId getBankAccountId() {
            return bankAccountId;
        }

        public AbstractDeleteBankAccountRequestBuilder(Retrofit retrofit, BankAccountId bankAccountId) {
            super(retrofit);
            this.bankAccountId = bankAccountId;
        }

    }

    public static abstract class AbstractGetBankAccountRequestBuilder<B extends AbstractGetBankAccountRequestBuilder, R, M extends BankAccount>
            extends RetrofitRequestBuilder<M, R> {
        protected BankAccountId bankAccountId;

        protected BankAccountId getBankAccountId() {
            return bankAccountId;
        }

        public AbstractGetBankAccountRequestBuilder(Retrofit retrofit, BankAccountId bankAccountId) {
            super(retrofit);
            this.bankAccountId = bankAccountId;
        }

    }

    public static abstract class AbstractListAllBankAccountsRequestBuilder<B extends AbstractListAllBankAccountsRequestBuilder, R, M extends BankAccount>
            extends RetrofitRequestBuilderPaginated<M, R, B, BankAccountId> {

        public AbstractListAllBankAccountsRequestBuilder(Retrofit retrofit) {
            super(retrofit);
        }

    }

    public static abstract class AbstractGetPrimaryBankAccountRequestBuilder<B extends AbstractGetPrimaryBankAccountRequestBuilder, R, M extends BankAccount>
            extends RetrofitRequestBuilder<M, R> {

        public AbstractGetPrimaryBankAccountRequestBuilder(Retrofit retrofit) {
            super(retrofit);
        }

    }

    public static abstract class AbstractUpdateBankAccountRequestBuilder<B extends AbstractUpdateBankAccountRequestBuilder, R, M extends BankAccount>
            extends IdempotentRetrofitRequestBuilder<M, R, B> {
        protected BankAccountId bankAccountId;
        protected Boolean isPrimary;
        protected String holderName;
        protected String bankName;
        protected String branchName;
        protected String bankAddress;
        protected String currency;
        protected String accountNumber;
        protected String swiftCode;
        protected String routingNumber;

        protected BankAccountId getBankAccountId() {
            return bankAccountId;
        }

        protected Boolean getIsPrimary() {
            return isPrimary;
        }

        protected String getHolderName() {
            return holderName;
        }

        protected String getBankName() {
            return bankName;
        }

        protected String getBranchName() {
            return branchName;
        }

        protected String getBankAddress() {
            return bankAddress;
        }

        protected String getCurrency() {
            return currency;
        }

        protected String getAccountNumber() {
            return accountNumber;
        }

        protected String getSwiftCode() {
            return swiftCode;
        }

        protected String getRoutingNumber() {
            return routingNumber;
        }

        public AbstractUpdateBankAccountRequestBuilder(Retrofit retrofit, BankAccountId bankAccountId) {
            super(retrofit);
            this.bankAccountId = bankAccountId;
        }

        public B withIsPrimary(Boolean isPrimary) {
            this.isPrimary = isPrimary;
            return (B)this;
        }

        public B withHolderName(String holderName) {
            this.holderName = holderName;
            return (B)this;
        }

        public B withBankName(String bankName) {
            this.bankName = bankName;
            return (B)this;
        }

        public B withBranchName(String branchName) {
            this.branchName = branchName;
            return (B)this;
        }

        public B withBankAddress(String bankAddress) {
            this.bankAddress = bankAddress;
            return (B)this;
        }

        public B withCurrency(String currency) {
            this.currency = currency;
            return (B)this;
        }

        public B withAccountNumber(String accountNumber) {
            this.accountNumber = accountNumber;
            return (B)this;
        }

        public B withSwiftCode(String swiftCode) {
            this.swiftCode = swiftCode;
            return (B)this;
        }

        public B withRoutingNumber(String routingNumber) {
            this.routingNumber = routingNumber;
            return (B)this;
        }
        
    }


}
