package jp.gopay.sdk.builders.batch_charge;

import jp.gopay.sdk.builders.ResourceMonitor;
import jp.gopay.sdk.builders.charge.ChargesBuilders;
import jp.gopay.sdk.models.common.ChargeId;
import jp.gopay.sdk.models.common.StoreId;
import jp.gopay.sdk.models.response.charge.Charge;
import retrofit2.Retrofit;

public class BatchCreateCharge extends AbstractBatchCreateCharge<Charge,
        ChargesBuilders.CreateChargeRequestBuilder,
        ChargesBuilders.GetChargeRequestBuilder> {

    public BatchCreateCharge(Retrofit retrofit, int createMaxRetry, int statusCheckTimeout) {
        super(retrofit, createMaxRetry, statusCheckTimeout);
    }

    @Override
    public ResourceMonitor<Charge> createChargeCompletionMonitor(Retrofit retrofit, StoreId storeId, ChargeId chargeId) {
        return ChargesBuilders.createChargeCompletionMonitor(retrofit, storeId, chargeId);
    }
}
