package jp.gopay.sdk.builders.cancel;

import jp.gopay.sdk.builders.IdempotentRetrofitRequestBuilder;
import jp.gopay.sdk.builders.Polling;
import jp.gopay.sdk.builders.RetrofitRequestBuilder;
import jp.gopay.sdk.builders.RetrofitRequestBuilderPaginated;
import jp.gopay.sdk.models.common.CancelId;
import jp.gopay.sdk.models.common.ChargeId;
import jp.gopay.sdk.models.common.StoreId;
import jp.gopay.sdk.models.response.cancel.Cancel;
import jp.gopay.sdk.types.CancelStatus;
import jp.gopay.sdk.types.MetadataMap;
import jp.gopay.sdk.utils.MetadataAdapter;
import retrofit2.Retrofit;

public abstract class AbstractCancelsBuilders {

    public static abstract class AbstractGetCancelRequestBuilder<B extends AbstractGetCancelRequestBuilder, R, M extends Cancel>
            extends RetrofitRequestBuilder<M, R> implements Polling<B>{
        protected StoreId storeId;
        protected ChargeId chargeId;
        protected CancelId cancelId;
        protected Boolean polling;

        protected StoreId getStoreId() {
            return storeId;
        }

        protected ChargeId getChargeId() {
            return chargeId;
        }

        protected CancelId getCancelId() {
            return cancelId;
        }

        public AbstractGetCancelRequestBuilder(Retrofit retrofit, StoreId storeId, ChargeId chargeId, CancelId cancelId) {
            super(retrofit);
            this.storeId = storeId;
            this.chargeId = chargeId;
            this.cancelId = cancelId;
        }

        @Override
        public B withPolling(boolean polling) {
            this.polling = polling;
            return (B)this;
        }
    }

    public static abstract class AbstractListAllCancelsRequestBuilder<B extends AbstractListAllCancelsRequestBuilder, R, M extends Cancel>
            extends RetrofitRequestBuilderPaginated<M, R, B, CancelId> {
        protected StoreId storeId;
        protected ChargeId chargeId;

        public AbstractListAllCancelsRequestBuilder(Retrofit retrofit, StoreId storeId, ChargeId chargeId) {
            super(retrofit);
            this.storeId = storeId;
            this.chargeId = chargeId;
        }
    }

    public static abstract class AbstractCreateCancelRequestBuilder<B extends AbstractCreateCancelRequestBuilder, R, M extends Cancel>
            extends IdempotentRetrofitRequestBuilder<M, R, B> {
        protected StoreId storeId;
        protected ChargeId chargeId;
        protected MetadataMap metadata;

        protected StoreId getStoreId() {
            return storeId;
        }

        protected ChargeId getChargeId() {
            return chargeId;
        }

        protected MetadataMap getMetadata() {
            return metadata;
        }

        public AbstractCreateCancelRequestBuilder(Retrofit retrofit, StoreId storeId, ChargeId chargeId) {
            super(retrofit);
            this.storeId = storeId;
            this.chargeId = chargeId;
        }

        public B withMetadata(MetadataMap metadata){
            this.metadata = metadata;
            return (B)this;
        }

        public <T> B withMetadata(T metadata, MetadataAdapter<T> adapter) {
            this.metadata = adapter.serialize(metadata);
            return (B)this;
        }

    }

    public static abstract class AbstractUpdateCancelRequestBuilder<B extends AbstractUpdateCancelRequestBuilder, R, M extends Cancel>
            extends IdempotentRetrofitRequestBuilder<M, R, B>{
        protected StoreId storeId;
        protected ChargeId chargeId;
        protected CancelId cancelId;
        protected MetadataMap metadata;
        protected CancelStatus status;

        protected StoreId getStoreId() {
            return storeId;
        }

        protected ChargeId getChargeId() {
            return chargeId;
        }

        protected CancelId getCancelId() {
            return cancelId;
        }

        public AbstractUpdateCancelRequestBuilder(Retrofit retrofit, StoreId storeId, ChargeId chargeId, CancelId cancelId) {
            super(retrofit);
            this.storeId = storeId;
            this.chargeId = chargeId;
            this.cancelId = cancelId;
        }

        public B withMetadata(MetadataMap metadata){
            this.metadata = metadata;
            return (B)this;
        }

        public <T> B withMetadata(T metadata, MetadataAdapter<T> adapter) {
            this.metadata = adapter.serialize(metadata);
            return (B)this;
        }

    }
}
