package jp.gopay.sdk.builders.charge;

import jp.gopay.sdk.builders.IdempotentRetrofitRequestBuilder;
import jp.gopay.sdk.builders.Polling;
import jp.gopay.sdk.builders.RetrofitRequestBuilder;
import jp.gopay.sdk.builders.RetrofitRequestBuilderPaginated;
import jp.gopay.sdk.models.common.*;
import jp.gopay.sdk.models.common.Void;
import jp.gopay.sdk.models.request.charge.CardChargeSearch;
import jp.gopay.sdk.models.response.charge.Charge;
import jp.gopay.sdk.types.MetadataMap;
import jp.gopay.sdk.utils.MetadataAdapter;
import retrofit2.Retrofit;

import java.util.Date;

public abstract class AbstractChargesBuilders {

    public static abstract class AbstractListChargesRequestBuilder<B extends AbstractListChargesRequestBuilder, R, M extends Charge>
            extends RetrofitRequestBuilderPaginated<M, R, B, ChargeId> {

        protected StoreId storeId;
        protected CardChargeSearch propertySearch = new CardChargeSearch();
        protected String metadataSearch;

        protected StoreId getStoreId() {
            return storeId;
        }

        public AbstractListChargesRequestBuilder(Retrofit retrofit) {
            super(retrofit);
        }

        public AbstractListChargesRequestBuilder(Retrofit retrofit, StoreId storeId) {
            super(retrofit);
            this.storeId = storeId;
        }

        public B withCardChargeSearch(CardChargeSearch search){
            this.propertySearch = search;
            return (B)this;
        }

        public B withMetadataSearch(String search){
            this.metadataSearch = search;
            return (B)this;
        }

    }

    public static abstract class AbstractGetChargeRequestBuilder<B extends AbstractGetChargeRequestBuilder, R, M extends Charge>
            extends RetrofitRequestBuilder<M, R> implements Polling<B>{

        protected StoreId storeId;
        protected ChargeId chargeId;
        protected Boolean polling;

        protected StoreId getStoreId() {
            return storeId;
        }

        protected ChargeId getChargeId() {
            return chargeId;
        }

        public AbstractGetChargeRequestBuilder(Retrofit retrofit, StoreId storeId, ChargeId chargeId) {
            super(retrofit);
            this.storeId = storeId;
            this.chargeId = chargeId;
        }

        public B withPolling(boolean polling){
            this.polling = polling;
            return (B)this;
        }

    }

    public static abstract class AbstractCreateChargeRequestBuilder<B extends AbstractCreateChargeRequestBuilder, R, M extends Charge>
            extends IdempotentRetrofitRequestBuilder<M, R, B> {

        protected TransactionTokenId transactionTokenId;
        protected MoneyLike money;
        protected Boolean capture;
        protected Date captureAt;
        protected MetadataMap metadata;

        protected TransactionTokenId getTransactionTokenId() {
            return transactionTokenId;
        }

        public MoneyLike getMoney() {
            return money;
        }

        public Date getCaptureAt() {
            return captureAt;
        }

        public Boolean getCapture() {
            return capture;
        }

        protected MetadataMap getMetadata() {
            return metadata;
        }

        public AbstractCreateChargeRequestBuilder(Retrofit retrofit, TransactionTokenId transactionTokenId, MoneyLike money, Boolean capture) {
            super(retrofit);
            this.transactionTokenId = transactionTokenId;
            this.money = money;
            this.capture = capture;
        }

        public B withCaptureAt(Date captureAt) {
            this.captureAt = captureAt;
            return (B)this;
        }

        public B withMetadata(MetadataMap metadata) {
            this.metadata = metadata;
            return (B)this;
        }

        public <T> B withMetadata(T metadata, MetadataAdapter<T> adapter) {
            this.metadata = adapter.serialize(metadata);
            return (B)this;
        }

    }

    public static abstract class AbstractUpdateChargeRequestBuilder<B extends AbstractUpdateChargeRequestBuilder, R, M extends Charge>
            extends IdempotentRetrofitRequestBuilder<M, R, B> {

        protected StoreId storeId;
        protected ChargeId chargeId;
        protected MetadataMap metadata;

        public StoreId getStoreId() {
            return storeId;
        }

        public ChargeId getChargeId() {
            return chargeId;
        }

        protected MetadataMap getMetadata() {
            return metadata;
        }

        public AbstractUpdateChargeRequestBuilder(Retrofit retrofit, StoreId storeId, ChargeId chargeId) {
            super(retrofit);
            this.storeId = storeId;
            this.chargeId = chargeId;
        }

        public B withMetadata(MetadataMap metadata) {
            this.metadata = metadata;
            return (B)this;
        }

        public <T> B withMetadata(T metadata, MetadataAdapter<T> adapter) {
            this.metadata = adapter.serialize(metadata);
            return (B)this;
        }
    }

    public static abstract class AbstractCaptureAuthorizedChargeRequestBuilder<B extends AbstractCaptureAuthorizedChargeRequestBuilder, R>
            extends IdempotentRetrofitRequestBuilder<Void, R, B> {

        protected StoreId storeId;
        protected ChargeId chargeId;
        protected MoneyLike money;

        public MoneyLike getMoney() {
            return money;
        }

        public StoreId getStoreId() {
            return storeId;
        }

        public ChargeId getChargeId() {
            return chargeId;
        }

        public AbstractCaptureAuthorizedChargeRequestBuilder(Retrofit retrofit, StoreId storeId, ChargeId chargeId, MoneyLike money) {
            super(retrofit);
            this.storeId = storeId;
            this.chargeId = chargeId;
            this.money = money;
        }
    }

}
