package jp.gopay.sdk.builders.exchangerate;

import jp.gopay.sdk.builders.IdempotentRetrofitRequestBuilder;
import jp.gopay.sdk.models.common.MoneyLike;
import retrofit2.Retrofit;

public abstract class AbstractExchangeRateBuilders {

    public static abstract class AbstractConvertMoneyBuilder<B extends AbstractConvertMoneyBuilder, R, M extends MoneyLike>
            extends IdempotentRetrofitRequestBuilder<M, R, B> {

        protected MoneyLike moneyToConvert;
        protected String targetCurrency;

        public AbstractConvertMoneyBuilder(Retrofit retrofit, MoneyLike moneyToConvert, String targetCurrency) {
            super(retrofit);
            this.moneyToConvert = moneyToConvert;
            this.targetCurrency = targetCurrency;
        }
    }
}
