package jp.gopay.sdk.builders.ledgers;

import jp.gopay.sdk.models.common.TransferId;
import jp.gopay.sdk.models.response.PaginatedList;
import jp.gopay.sdk.models.response.ledger.Ledger;
import jp.gopay.sdk.resources.LedgersResource;
import retrofit2.Call;
import retrofit2.Retrofit;

public abstract class LedgersBuilders {

    public static class ListLedgersRequestBuilder
            extends AbstractLedgersBuilders.AbstractListLedgersRequestBuilder<ListLedgersRequestBuilder, LedgersResource, Ledger>{

        public ListLedgersRequestBuilder(Retrofit retrofit, TransferId transferId) {
            super(retrofit, transferId);
        }

        @Override
        protected Call<PaginatedList<Ledger>> getRequest(LedgersResource resource) {
            return resource.listLedgers(transferId, all, from, to, min, max, currency, getLimit(), getCursorDirection(), getCursor());
        }
    }
}
