package jp.gopay.sdk.builders.merchant;

import jp.gopay.sdk.builders.merchant.AbstractMerchantsBuilders.*;
import jp.gopay.sdk.models.common.StoreId;
import jp.gopay.sdk.models.request.merchant.MerchantsReq;
import jp.gopay.sdk.models.response.PaginatedList;
import jp.gopay.sdk.models.response.merchant.MerchantCompanyContactInfo;
import jp.gopay.sdk.models.response.merchant.MerchantVerificationData;
import jp.gopay.sdk.models.response.merchant.MerchantWithConfiguration;
import jp.gopay.sdk.models.response.merchant.Transaction;
import jp.gopay.sdk.resources.MerchantsResource;
import jp.gopay.sdk.types.BusinessType;
import org.joda.time.format.ISODateTimeFormat;
import retrofit2.Call;
import retrofit2.Retrofit;

import javax.annotation.Nullable;
import java.net.URL;

public abstract class MerchantsBuilders {

    public static class CreateMerchantVerificationRequestBuilder
            extends AbstractCreateMerchantVerificationRequestBuilder<CreateMerchantVerificationRequestBuilder, MerchantsResource, MerchantVerificationData>{

        public CreateMerchantVerificationRequestBuilder(Retrofit retrofit, URL homepageUrl, String companyDescription, MerchantCompanyContactInfo companyContactInfo, BusinessType businessType, String systemManagerName) {
            super(retrofit, homepageUrl, companyDescription, companyContactInfo, businessType, systemManagerName);
        }

        @Override
        protected Call<MerchantVerificationData> getRequest(MerchantsResource resource) {
            return resource.createVerification(
                    new MerchantsReq(homepageUrl, companyDescription, getContactInfo(), businessType, systemManagerName, systemManagerNumber, systemManagerEmail, recurringTokenRequest, recurringTokenRequestReason, allowEmptyCvv), idempotencyKey);
        }

    }

    public static class GetMerchantVerificationRequestBuilder
            extends AbstractGetMerchantVerificationRequestBuilder<GetMerchantVerificationRequestBuilder, MerchantsResource, MerchantVerificationData>{

        public GetMerchantVerificationRequestBuilder(Retrofit retrofit) {
            super(retrofit);
        }

        @Override
        protected Call<MerchantVerificationData> getRequest(MerchantsResource resource){
            return resource.getVerification();
        }
    }

    public static class GetTransactionHistoryRequestBuilder
            extends AbstractGetTransactionHistoryRequestBuilder<GetTransactionHistoryRequestBuilder, MerchantsResource, Transaction>{

        public GetTransactionHistoryRequestBuilder(Retrofit retrofit, @Nullable StoreId storeId) {
            super(retrofit, storeId);
        }

        @Override
        protected Call<PaginatedList<Transaction>> getRequest(MerchantsResource resource){
            String fromString = (from == null) ? null : ISODateTimeFormat.dateTime().print(from.getTime());
            String toString = (to == null) ? null : ISODateTimeFormat.dateTime().print(to.getTime());

            if(storeId==null){
                return resource.getTransactionHistory(getLimit(), getCursorDirection(), getCursor(), fromString, toString, status, type, mode, search, all);
            }
            return resource.getStoreTransactionHistory(storeId, getLimit(), getCursorDirection(), getCursor(), fromString, toString, status, type, mode, search, all);
        }
    }

    public static class UpdateMerchantVerificationRequestBuilder
            extends AbstractUpdateMerchantVerificationRequestBuilder<UpdateMerchantVerificationRequestBuilder, MerchantsResource, MerchantVerificationData>{

        public UpdateMerchantVerificationRequestBuilder(Retrofit retrofit) {
            super(retrofit);
        }

        @Override
        protected Call<MerchantVerificationData> getRequest(MerchantsResource resource){
            return resource.updateVerification(
                    new MerchantsReq(homepageUrl, companyDescription, getCompayContactInfo(), businessType, systemManagerName, systemManagerNumber, systemManagerEmail, recurringTokenRequest, recurringTokenRequestReason, allowEmptyCvv), idempotencyKey);
        }
    }

    public static class GetMeRequestBuilder
            extends AbstractGetMeRequestBuilder<GetMeRequestBuilder, MerchantsResource, MerchantWithConfiguration>{

        public GetMeRequestBuilder(Retrofit retrofit) {
            super(retrofit);
        }

        @Override
        protected Call<MerchantWithConfiguration> getRequest(MerchantsResource resource){
            return resource.me();
        }
    }

}
