package jp.gopay.sdk.builders.refund;

import jp.gopay.sdk.builders.IdempotentRetrofitRequestBuilder;
import jp.gopay.sdk.builders.Polling;
import jp.gopay.sdk.builders.RetrofitRequestBuilder;
import jp.gopay.sdk.builders.RetrofitRequestBuilderPaginated;
import jp.gopay.sdk.models.common.ChargeId;
import jp.gopay.sdk.models.common.RefundId;
import jp.gopay.sdk.models.common.StoreId;
import jp.gopay.sdk.models.request.refund.RefundCreateData;
import jp.gopay.sdk.models.response.refund.Refund;
import jp.gopay.sdk.types.MetadataMap;
import jp.gopay.sdk.types.RefundReason;
import jp.gopay.sdk.utils.MetadataAdapter;
import retrofit2.Retrofit;

import java.math.BigInteger;

public abstract class AbstractRefundBuilders {

    public static abstract class AbstractListRefundsRequestBuilder<B extends AbstractListRefundsRequestBuilder, R, M extends Refund>
            extends RetrofitRequestBuilderPaginated<M, R, B, RefundId> {

        protected StoreId storeId;
        protected ChargeId chargeId;
        protected String metadataSearch;

        protected StoreId getStoreId() {
            return storeId;
        }

        protected ChargeId getChargeId() {
            return chargeId;
        }

        public B withMetadataSearch(String search){
            this.metadataSearch = search;
            return (B)this;
        }

        public AbstractListRefundsRequestBuilder(Retrofit retrofit, StoreId storeId, ChargeId chargeId) {
            super(retrofit);
            this.storeId = storeId;
            this.chargeId = chargeId;
        }

    }

    public static abstract class AbstractGetRefundRequestBuilder<B extends AbstractGetRefundRequestBuilder, R, M extends Refund>
            extends RetrofitRequestBuilder<M, R> implements Polling<B> {

        protected StoreId storeId;
        protected ChargeId chargeId;
        protected RefundId refundId;
        protected Boolean polling;

        protected StoreId getStoreId() {
            return storeId;
        }

        protected ChargeId getChargeId() {
            return chargeId;
        }

        protected RefundId getRefundId() {
            return refundId;
        }

        public AbstractGetRefundRequestBuilder(Retrofit retrofit, StoreId storeId, ChargeId chargeId, RefundId refundId) {
            super(retrofit);
            this.storeId = storeId;
            this.chargeId = chargeId;
            this.refundId = refundId;
        }

        public B withPolling(boolean polling){
            this.polling = polling;
            return (B)this;
        }

    }

    public static abstract class AbstractCreateRefundRequestBuilder<B extends AbstractCreateRefundRequestBuilder, R, M extends Refund>
            extends IdempotentRetrofitRequestBuilder<M, R, B> {

        protected StoreId storeId;
        protected ChargeId chargeId;
        protected BigInteger amount;
        protected String currency;
        protected RefundReason reason;
        protected String message;
        protected MetadataMap metadata;

        protected StoreId getStoreId() {
            return storeId;
        }

        protected ChargeId getChargeId() {
            return chargeId;
        }

        protected BigInteger getAmount() {
            return amount;
        }

        protected String getCurrency() {
            return currency;
        }

        protected RefundReason getReason() {
            return reason;
        }

        protected String getMessage() {
            return message;
        }

        protected MetadataMap getMetadata() {
            return metadata;
        }

        public AbstractCreateRefundRequestBuilder(Retrofit retrofit, StoreId storeId, ChargeId chargeId, BigInteger amount, String currency, RefundReason reason) {
            super(retrofit);
            this.storeId = storeId;
            this.chargeId = chargeId;
            this.amount = amount;
            this.currency = currency;
            this.reason = reason;
        }

        public B withMetadata(MetadataMap metadata) {
            this.metadata = metadata;
            return (B)this;
        }

        public <T> B withMetadata(T metadata, MetadataAdapter<T> adapter) {
            this.metadata = adapter.serialize(metadata);
            return (B)this;
        }

        public B withMessage(String message) {
            this.message = message;
            return (B)this;
        }

        RefundCreateData getData(){
            return new RefundCreateData(amount, currency, reason, message, metadata);
        }

    }
}
