package jp.gopay.sdk.builders.refund;

import jp.gopay.sdk.builders.ResourceMonitor;
import jp.gopay.sdk.builders.ResourcePredicate;
import jp.gopay.sdk.builders.refund.AbstractRefundBuilders.AbstractCreateRefundRequestBuilder;
import jp.gopay.sdk.builders.refund.AbstractRefundBuilders.AbstractGetRefundRequestBuilder;
import jp.gopay.sdk.builders.refund.AbstractRefundBuilders.AbstractListRefundsRequestBuilder;
import jp.gopay.sdk.models.common.ChargeId;
import jp.gopay.sdk.models.common.RefundId;
import jp.gopay.sdk.models.common.StoreId;
import jp.gopay.sdk.models.response.PaginatedList;
import jp.gopay.sdk.models.response.refund.Refund;
import jp.gopay.sdk.resources.RefundsResource;
import jp.gopay.sdk.types.RefundReason;
import jp.gopay.sdk.types.RefundStatus;
import retrofit2.Call;
import retrofit2.Retrofit;

import java.math.BigInteger;

public abstract class RefundBuilders {

    public static class ListRefundsRequestBuilder
            extends AbstractListRefundsRequestBuilder<ListRefundsRequestBuilder, RefundsResource, Refund>{

        public ListRefundsRequestBuilder(Retrofit retrofit, StoreId storeId, ChargeId chargeId) {
            super(retrofit, storeId, chargeId);
        }

        @Override
        protected Call<PaginatedList<Refund>> getRequest(RefundsResource resource) {
            return resource.list(storeId, chargeId, getLimit(), getCursorDirection(), getCursor(), metadataSearch);
        }
    }

    public static class GetRefundRequestBuilder
            extends AbstractGetRefundRequestBuilder<GetRefundRequestBuilder, RefundsResource, Refund>{

        public GetRefundRequestBuilder(Retrofit retrofit, StoreId storeId, ChargeId chargeId, RefundId refundId) {
            super(retrofit, storeId, chargeId, refundId);
        }

        @Override
        protected Call<Refund> getRequest(RefundsResource resource) {
            return resource.get(storeId, chargeId, refundId, polling);
        }
    }

    public static class CreateRefundRequestBuilder
            extends AbstractCreateRefundRequestBuilder<CreateRefundRequestBuilder, RefundsResource, Refund>{

        public CreateRefundRequestBuilder(Retrofit retrofit, StoreId storeId, ChargeId chargeId, BigInteger amount, String currency, RefundReason reason) {
            super(retrofit, storeId, chargeId, amount, currency, reason);
        }

        @Override
        protected Call<Refund> getRequest(RefundsResource resource) {
            return resource.create(storeId, chargeId, getData(), idempotencyKey);
        }
    }

    public static ResourceMonitor<Refund> createRefundCompletionMonitor(Retrofit retrofit, StoreId storeId, ChargeId chargeId, RefundId refundId) {
        return new ResourceMonitor<>(new RefundBuilders.GetRefundRequestBuilder(retrofit, storeId, chargeId, refundId)
                .withPolling(true),
                new ResourcePredicate<Refund>() {
            @Override
            public boolean test(Refund resource) {
                return resource.getStatus() != RefundStatus.PENDING;
            }
        });
    }
}
