package jp.gopay.sdk.builders.transactiontoken;

import jp.gopay.sdk.builders.IdempotentRetrofitRequestBuilder;
import jp.gopay.sdk.builders.RetrofitRequestBuilder;
import jp.gopay.sdk.builders.RetrofitRequestBuilderPaginated;
import jp.gopay.sdk.models.common.*;
import jp.gopay.sdk.models.common.Void;
import jp.gopay.sdk.models.request.transactiontoken.PaymentData;
import jp.gopay.sdk.models.response.GoPayBinaryData;
import jp.gopay.sdk.models.response.transactiontoken.TemporaryTokenAlias;
import jp.gopay.sdk.models.response.transactiontoken.TransactionToken;
import jp.gopay.sdk.models.response.transactiontoken.TransactionTokenWithData;
import jp.gopay.sdk.types.MetadataMap;
import jp.gopay.sdk.types.ProcessingMode;
import jp.gopay.sdk.types.RecurringTokenInterval;
import jp.gopay.sdk.types.TransactionTokenType;
import jp.gopay.sdk.utils.MetadataAdapter;
import retrofit2.Retrofit;

import java.util.Date;

public abstract class AbstractTransactionTokensBuilders {

    public static abstract class AbstractDeleteTransactionTokenRequestBuilder<B extends AbstractDeleteTransactionTokenRequestBuilder, R>
            extends RetrofitRequestBuilder<Void, R> {

        protected StoreId storeId;
        protected TransactionTokenId transactionTokenId;

        protected StoreId getStoreId() {
            return storeId;
        }

        protected TransactionTokenId getTransactionTokenId() {
            return transactionTokenId;
        }

        public AbstractDeleteTransactionTokenRequestBuilder(Retrofit retrofit, StoreId storeId, TransactionTokenId transactionTokenId) {
            super(retrofit);
            this.storeId = storeId;
            this.transactionTokenId = transactionTokenId;
        }

    }

    public static abstract class AbstractGetTransactionTokenRequestBuilder<B extends AbstractGetTransactionTokenRequestBuilder, R, M extends TransactionTokenWithData>
            extends RetrofitRequestBuilder<M, R> {

        protected StoreId storeId;
        protected TransactionTokenId transactionTokenId;

        protected StoreId getStoreId() {
            return storeId;
        }

        protected TransactionTokenId getTransactionTokenId() {
            return transactionTokenId;
        }

        public AbstractGetTransactionTokenRequestBuilder(Retrofit retrofit, StoreId storeId, TransactionTokenId transactionTokenId) {
            super(retrofit);
            this.storeId = storeId;
            this.transactionTokenId = transactionTokenId;
        }

    }


    public static abstract class AbstractCreateTransactionTokenRequestBuilder<B extends AbstractCreateTransactionTokenRequestBuilder, R, M extends TransactionTokenWithData>
            extends IdempotentRetrofitRequestBuilder<M, R, B> {

        protected String email;
        protected RecurringTokenInterval usageLimit;
        protected PaymentData paymentData;
        protected TransactionTokenType type;
        protected MetadataMap metadata = new MetadataMap();

        protected String getEmail() {
            return email;
        }

        protected RecurringTokenInterval getUsageLimit() {
            return usageLimit;
        }

        protected MetadataMap getMetadata() {
            return metadata;
        }

        protected PaymentData getPaymentData() {
            return paymentData;
        }

        protected TransactionTokenType getType() {
            return type;
        }

        public AbstractCreateTransactionTokenRequestBuilder(Retrofit retrofit,
                                                    String email,
                                                    PaymentData paymentData,
                                                    TransactionTokenType type) {
            super(retrofit);
            this.paymentData = paymentData;
            this.email = email;
            this.type = type;
        }

        public B withUsageLimit(RecurringTokenInterval usageLimit){
            this.usageLimit = usageLimit;
            return (B)this;
        }


        public B withMetadata(MetadataMap metadata){
            this.metadata.putAll(metadata);
            return (B)this;
        }

        public <T> B withMetadata(T metadata, MetadataAdapter<T> adapter) {
            this.metadata.putAll(adapter.serialize(metadata));
            return (B)this;
        }

        public B withCustomerId(GopayCustomerId customerId){
            this.metadata.put(GopayCustomerId.metadataKey, customerId.toString());
            return (B)this;
        }
    }

    public static abstract class AbstractUpdateTransactionTokenRequestBuilder<B extends AbstractUpdateTransactionTokenRequestBuilder, R, M extends TransactionTokenWithData>
            extends IdempotentRetrofitRequestBuilder<M, R, B>{

        protected String email;
        protected MetadataMap metadata = new MetadataMap();
        protected Integer cvv;
        protected StoreId storeId;
        protected TransactionTokenId transactionTokenId;

        protected String getAmount() {
            return email;
        }

        protected MetadataMap getMetadata() {
            return metadata;
        }

        protected Integer getCvv() {
            return cvv;
        }

        protected StoreId getStoreId() {
            return storeId;
        }

        protected TransactionTokenId getTransactionTokenId() {
            return transactionTokenId;
        }

        public AbstractUpdateTransactionTokenRequestBuilder(Retrofit retrofit, StoreId storeId, TransactionTokenId transactionTokenId) {
            super(retrofit);
            this.storeId = storeId;
            this.transactionTokenId = transactionTokenId;
        }

        public B withEmail(String email) {
            this.email = email;
            return (B) this;
        }

        public B withMetadata(MetadataMap metadata) {
            this.metadata.putAll(metadata);
            return (B) this;
        }

        public <T> B withMetadata(T metadata, MetadataAdapter<T> adapter) {
            this.metadata.putAll(adapter.serialize(metadata));
            return (B)this;
        }

        public B withCustomerId(GopayCustomerId customerId){
            this.metadata.put(GopayCustomerId.metadataKey, customerId.toString());
            return (B)this;
        }

        public B withCvv(Integer cvv) {
            this.cvv = cvv;
            return (B)this;
        }

    }

    public static abstract class AbstractListTransactionTokensRequestBuilder<B extends AbstractListTransactionTokensRequestBuilder, R, M extends TransactionToken>
            extends RetrofitRequestBuilderPaginated<M, R, B, TransactionTokenId>{
        protected StoreId storeId;
        protected Boolean all;
        protected String search;
        protected GopayCustomerId customerId;
        protected ProcessingMode mode;
        protected TransactionTokenType type;

        public AbstractListTransactionTokensRequestBuilder(Retrofit retrofit, StoreId storeId) {
            super(retrofit);
            this.storeId = storeId;
        }

        public Boolean getAll() {
            return all;
        }

        public String getSearch() {
            return search;
        }

        public GopayCustomerId getCustomerId() {
            return customerId;
        }

        public ProcessingMode getMode() {
            return mode;
        }

        public TransactionTokenType getType() {
            return type;
        }

        protected StoreId getStoreId() {
            return storeId;
        }

        public B withListAll(Boolean all){
            this.all = all;
            return (B)this;
        }

        public B withSearch(String searchString) {
            this.search = searchString;
            return (B)this;
        }

        public B withCustomerId(GopayCustomerId customerId){
            this.customerId = customerId;
            return (B)this;
        }

        public B withMode(ProcessingMode mode){
            this.mode = mode;
            return (B)this;
        }

        public B withType(TransactionTokenType type){
            this.type = type;
            return (B)this;
        }

    }

    public static abstract class AbstractListTransactionTokensMerchantRequestBuilder<B extends AbstractListTransactionTokensMerchantRequestBuilder, R, M extends TransactionToken>
            extends RetrofitRequestBuilderPaginated<M, R, B, TransactionTokenId> {

        protected Boolean all;
        protected String search;
        protected GopayCustomerId customerId;
        protected ProcessingMode mode;
        protected TransactionTokenType type;

        public AbstractListTransactionTokensMerchantRequestBuilder(Retrofit retrofit) {
            super(retrofit);
        }

        protected String getSearch() {
            return search;
        }

        protected GopayCustomerId getCustomerId() {
            return customerId;
        }

        protected ProcessingMode getMode() {
            return mode;
        }

        public TransactionTokenType getType() {
            return type;
        }

        public Boolean getAll() {
            return all;
        }

        public B withListAll(Boolean all){
            this.all = all;
            return (B)this;
        }

        public B withSearch(String searchString) {
            this.search = searchString;
            return (B)this;
        }

        public B withCustomerId(GopayCustomerId customerId){
            this.customerId = customerId;
            return (B)this;
        }

        public B withMode(ProcessingMode mode){
            this.mode = mode;
            return (B)this;
        }

        public B withType(TransactionTokenType type){
            this.type = type;
            return (B)this;
        }

    }

    public static abstract class AbstractCreateTemporaryTokenAliasRequestBuilder<B extends AbstractCreateTemporaryTokenAliasRequestBuilder, R, M extends TemporaryTokenAlias>
            extends IdempotentRetrofitRequestBuilder<M, R, B> {

        protected TransactionTokenId transactionTokenId;
        protected Date validUntil;
        protected MetadataMap metadata;

        public AbstractCreateTemporaryTokenAliasRequestBuilder(Retrofit retrofit, TransactionTokenId transactionTokenId) {
            super(retrofit);
            this.transactionTokenId = transactionTokenId;
        }

        public TransactionTokenId getTransactionTokenId() {
            return transactionTokenId;
        }

        public Date getValidUntil() {
            return validUntil;
        }

        public MetadataMap getMetadata() {
            return metadata;
        }

        public B withValidUntil(Date validUntil){
            this.validUntil = validUntil;
            return (B)this;
        }

        public B withMetadata(MetadataMap metadata){
            this.metadata = metadata;
            return (B)this;
        }

        public <T> B withMetadata(T metadata, MetadataAdapter<T> adapter) {
            this.metadata = adapter.serialize(metadata);
            return (B)this;
        }
    }

    public static abstract class AbstractGetTemporaryTokenAliasRequestBuilder<B extends AbstractGetTemporaryTokenAliasRequestBuilder, R, M extends TemporaryTokenAlias>
            extends RetrofitRequestBuilder<M, R> {

        protected StoreId storeId;
        protected TemporaryTokenAliasId aliasId;

        public AbstractGetTemporaryTokenAliasRequestBuilder(Retrofit retrofit, StoreId storeId, TemporaryTokenAliasId aliasId) {
            super(retrofit);
            this.storeId = storeId;
            this.aliasId = aliasId;
        }

        public StoreId getStoreId() {
            return storeId;
        }

        public TemporaryTokenAliasId getAliasId() {
            return aliasId;
        }

    }

    public static abstract class AbstractGetTemporaryTokenAliasAsImageRequestBuilder<B extends AbstractGetTemporaryTokenAliasAsImageRequestBuilder, R, M extends GoPayBinaryData>
            extends RetrofitRequestBuilder<M, R> {

        protected StoreId storeId;
        protected TemporaryTokenAliasId aliasId;

        public AbstractGetTemporaryTokenAliasAsImageRequestBuilder(Retrofit retrofit, StoreId storeId, TemporaryTokenAliasId aliasId) {
            super(retrofit);
            this.storeId = storeId;
            this.aliasId = aliasId;
        }

        public StoreId getStoreId() {
            return storeId;
        }

        public TemporaryTokenAliasId getAliasId() {
            return aliasId;
        }

    }

    public static abstract class AbstractDeleteTemporaryTokenAliasRequestBuilder<B extends AbstractDeleteTemporaryTokenAliasRequestBuilder, R, M extends Void>
            extends RetrofitRequestBuilder<M, R> {

        protected StoreId storeId;
        protected TemporaryTokenAliasId aliasId;

        public AbstractDeleteTemporaryTokenAliasRequestBuilder(Retrofit retrofit, StoreId storeId, TemporaryTokenAliasId aliasId) {
            super(retrofit);
            this.storeId = storeId;
            this.aliasId = aliasId;
        }

        public StoreId getStoreId() {
            return storeId;
        }

        public TemporaryTokenAliasId getAliasId() {
            return aliasId;
        }
    }

}
