package jp.gopay.sdk.builders.transactiontoken;

import jp.gopay.sdk.builders.transactiontoken.AbstractTransactionTokensBuilders.*;
import jp.gopay.sdk.models.common.StoreId;
import jp.gopay.sdk.models.common.TemporaryTokenAliasId;
import jp.gopay.sdk.models.common.TransactionTokenId;
import jp.gopay.sdk.models.common.Void;
import jp.gopay.sdk.models.request.transactiontoken.CreateReq;
import jp.gopay.sdk.models.request.transactiontoken.PaymentData;
import jp.gopay.sdk.models.request.transactiontoken.TemporaryTokenAliasReq;
import jp.gopay.sdk.models.request.transactiontoken.UpdateReq;
import jp.gopay.sdk.models.response.GoPayBinaryData;
import jp.gopay.sdk.models.response.PaginatedList;
import jp.gopay.sdk.models.response.transactiontoken.TemporaryTokenAlias;
import jp.gopay.sdk.models.response.transactiontoken.TransactionToken;
import jp.gopay.sdk.models.response.transactiontoken.TransactionTokenWithData;
import jp.gopay.sdk.resources.TransactionTokensResource;
import jp.gopay.sdk.types.TransactionTokenType;
import retrofit2.Call;
import retrofit2.Retrofit;

public abstract class TransactionTokensBuilders {

    public static class DeleteTransactionTokenRequestBuilder
            extends AbstractDeleteTransactionTokenRequestBuilder<DeleteTransactionTokenRequestBuilder, TransactionTokensResource>{

        public DeleteTransactionTokenRequestBuilder(Retrofit retrofit, StoreId storeId, TransactionTokenId transactionTokenId) {
            super(retrofit, storeId, transactionTokenId);
        }

        @Override
        protected Call<Void> getRequest(TransactionTokensResource resource) {
            return resource.delete(storeId,transactionTokenId);
        }
    }

    public static class GetTransactionTokenRequestBuilder
            extends AbstractGetTransactionTokenRequestBuilder<GetTransactionTokenRequestBuilder, TransactionTokensResource, TransactionTokenWithData>{

        public GetTransactionTokenRequestBuilder(Retrofit retrofit, StoreId storeId, TransactionTokenId transactionTokenId) {
            super(retrofit, storeId, transactionTokenId);
        }

        @Override
        protected Call<TransactionTokenWithData> getRequest(TransactionTokensResource resource) {
            return resource.get(storeId, transactionTokenId);
        }
    }

    public static class CreateTransactionTokenRequestBuilder
            extends AbstractCreateTransactionTokenRequestBuilder<CreateTransactionTokenRequestBuilder, TransactionTokensResource, TransactionTokenWithData>{

        public CreateTransactionTokenRequestBuilder(Retrofit retrofit, String email, PaymentData paymentData, TransactionTokenType type) {
            super(retrofit, email, paymentData, type);
        }

        @Override
        protected Call<TransactionTokenWithData> getRequest(TransactionTokensResource resource) {
            CreateReq dataToPost = new CreateReq(email, type, usageLimit, metadata, paymentData);

            return resource.create(dataToPost, idempotencyKey);
        }
    }

    public static class UpdateTransactionTokenRequestBuilder
            extends AbstractUpdateTransactionTokenRequestBuilder<UpdateTransactionTokenRequestBuilder, TransactionTokensResource, TransactionTokenWithData>{

        public UpdateTransactionTokenRequestBuilder(Retrofit retrofit, StoreId storeId, TransactionTokenId transactionTokenId) {
            super(retrofit, storeId, transactionTokenId);
        }

        @Override
        protected Call<TransactionTokenWithData> getRequest(TransactionTokensResource resource) {
            UpdateReq dataToPost = new UpdateReq(email, metadata, cvv);
            return resource.update(storeId, transactionTokenId, dataToPost, idempotencyKey);
        }
    }

    public static class ListTransactionTokensRequestBuilder
            extends AbstractListTransactionTokensRequestBuilder<ListTransactionTokensRequestBuilder, TransactionTokensResource, TransactionToken>{

        public ListTransactionTokensRequestBuilder(Retrofit retrofit, StoreId storeId) {
            super(retrofit, storeId);
        }

        @Override
        protected Call<PaginatedList<TransactionToken>> getRequest(TransactionTokensResource resource){
            return resource.list(storeId, getLimit(), getCursorDirection(), getCursor(), all, search, mode, type, customerId);
        }
    }

    public static class ListTransactionTokensMerchantRequestBuilder
            extends AbstractListTransactionTokensMerchantRequestBuilder<ListTransactionTokensMerchantRequestBuilder, TransactionTokensResource, TransactionToken>{

        public ListTransactionTokensMerchantRequestBuilder(Retrofit retrofit) {
            super(retrofit);
        }

        @Override
        protected Call<PaginatedList<TransactionToken>> getRequest(TransactionTokensResource resource){
            return resource.listMerchant(getLimit(), getCursorDirection(), getCursor(), all, search, mode, type, customerId);
        }
    }

    public static class CreateTemporaryTokenAliasRequestBuilder
            extends AbstractCreateTemporaryTokenAliasRequestBuilder<CreateTemporaryTokenAliasRequestBuilder, TransactionTokensResource, TemporaryTokenAlias>{

        public CreateTemporaryTokenAliasRequestBuilder(Retrofit retrofit, TransactionTokenId transactionTokenId) {
            super(retrofit, transactionTokenId);
        }

        @Override
        protected Call<TemporaryTokenAlias> getRequest(TransactionTokensResource resource) {
            return resource.createAlias(
                    new TemporaryTokenAliasReq(
                            transactionTokenId,
                            validUntil,
                            metadata
                    ),
                    getIdempotencyKey()
            );
        }
    }

    public static class GetTemporaryTokenAliasRequestBuilder
            extends AbstractGetTemporaryTokenAliasRequestBuilder<GetTemporaryTokenAliasRequestBuilder, TransactionTokensResource, TemporaryTokenAlias>{

        public GetTemporaryTokenAliasRequestBuilder(Retrofit retrofit, StoreId storeId, TemporaryTokenAliasId aliasId) {
            super(retrofit, storeId, aliasId);
        }

        @Override
        protected Call<TemporaryTokenAlias> getRequest(TransactionTokensResource resource) {
            return resource.getAlias(storeId, aliasId);
        }

    }

    public static class GetTemporaryTokenAliasAsImageRequestBuilder
            extends AbstractGetTemporaryTokenAliasAsImageRequestBuilder<GetTemporaryTokenAliasAsImageRequestBuilder, TransactionTokensResource, GoPayBinaryData>{

        public GetTemporaryTokenAliasAsImageRequestBuilder(Retrofit retrofit, StoreId storeId, TemporaryTokenAliasId aliasId) {
            super(retrofit, storeId, aliasId);
        }

        @Override
        protected Call<GoPayBinaryData> getRequest(TransactionTokensResource resource) {
            return resource.getAliasAsImage(storeId, aliasId, "qr");
        }
    }

    public static class DeleteTemporaryTokenAliasRequestBuilder
            extends AbstractDeleteTemporaryTokenAliasRequestBuilder<DeleteTemporaryTokenAliasRequestBuilder, TransactionTokensResource, Void>{

        public DeleteTemporaryTokenAliasRequestBuilder(Retrofit retrofit, StoreId storeId, TemporaryTokenAliasId aliasId) {
            super(retrofit, storeId, aliasId);
        }

        @Override
        protected Call<Void> getRequest(TransactionTokensResource resource) {
            return resource.deleteAlias(storeId, aliasId);
        }
    }
}
