package jp.gopay.sdk.builders.transfer;

import jp.gopay.sdk.builders.RetrofitRequestBuilder;
import jp.gopay.sdk.builders.RetrofitRequestBuilderPaginated;
import jp.gopay.sdk.models.common.TransferId;
import jp.gopay.sdk.models.response.transfer.Transfer;
import retrofit2.Retrofit;

public abstract class AbstractTransferBuilders {

    public static abstract class AbstractListTransferRequestBuilder<B extends AbstractListTransferRequestBuilder, R, M extends Transfer>
            extends RetrofitRequestBuilderPaginated<M, R, B, TransferId> {

        public AbstractListTransferRequestBuilder(Retrofit retrofit) {
            super(retrofit);
        }

    }


    public static abstract class AbstractGetTransferRequestBuilder<B extends AbstractGetTransferRequestBuilder, R, M extends Transfer>
            extends RetrofitRequestBuilder<M, R> {

        protected TransferId transferId;

        protected TransferId getTransferId() {
            return transferId;
        }

        public AbstractGetTransferRequestBuilder(Retrofit retrofit, TransferId transferId) {
            super(retrofit);
            this.transferId = transferId;
        }

    }


}
