package jp.gopay.sdk.builders.transfer;

import jp.gopay.sdk.builders.transfer.AbstractTransferBuilders.AbstractGetTransferRequestBuilder;
import jp.gopay.sdk.builders.transfer.AbstractTransferBuilders.AbstractListTransferRequestBuilder;
import jp.gopay.sdk.models.common.TransferId;
import jp.gopay.sdk.models.response.PaginatedList;
import jp.gopay.sdk.models.response.transfer.Transfer;
import jp.gopay.sdk.resources.TransfersResource;
import retrofit2.Call;
import retrofit2.Retrofit;

public abstract class TransferBuilders {

    public static class ListTransferRequestBuilder
            extends AbstractListTransferRequestBuilder<ListTransferRequestBuilder, TransfersResource, Transfer>{

        public ListTransferRequestBuilder(Retrofit retrofit) {
            super(retrofit);
        }

        @Override
        protected Call<PaginatedList<Transfer>> getRequest(TransfersResource resource) {
            return resource.list(getLimit(), getCursorDirection(), getCursor());
        }
    }

    public static class GetTransferRequestBuilder
            extends AbstractGetTransferRequestBuilder<GetTransferRequestBuilder, TransfersResource, Transfer>{

        public GetTransferRequestBuilder(Retrofit retrofit, TransferId transferId) {
            super(retrofit, transferId);
        }

        @Override
        protected Call<Transfer> getRequest(TransfersResource resource) {
            return resource.get(transferId);
        }
    }
}
