package jp.gopay.sdk.converters;

import jp.gopay.sdk.models.response.GoPayBinaryData;
import okhttp3.ResponseBody;
import retrofit2.Converter;
import retrofit2.Retrofit;

import javax.annotation.Nullable;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

public class BinaryDataConverterFactory extends Converter.Factory{

    @Nullable
    @Override
    public Converter<ResponseBody, ?> responseBodyConverter(Type type, Annotation[] annotations, Retrofit retrofit) {

        if(type.equals(GoPayBinaryData.class)){

            return new Converter<ResponseBody, GoPayBinaryData>() {
                @Override
                public GoPayBinaryData convert(ResponseBody responseBody) throws IOException {
                    return new GoPayBinaryData(responseBody.bytes());
                }
            };

        } else return null;
    }
}
