package jp.gopay.sdk.models.common.bankaccounts;

import jp.gopay.sdk.types.BankAccountCountry;
import jp.gopay.sdk.types.BankAccountType;

public class AmericanBankAccount extends BaseBankAccount{

    public AmericanBankAccount(String holderName, String bankName, String currency, String accountNumber, String routingNumber, BankAccountType accountType) {
        setCommonFields(BankAccountCountry.US, holderName, bankName, currency, accountNumber, accountType);
        this.setRoutingNumber(routingNumber);
    }

    public AmericanBankAccount withBranchName(String branchName){
        this.setBranchName(branchName);
        return this;
    }

    public AmericanBankAccount withBankAddress(String bankAddress){
        this.setBankAddress(bankAddress);
        return this;
    }
}
