package jp.gopay.sdk.models.common.stores;

import com.google.gson.annotations.SerializedName;
import org.joda.time.Period;

import java.math.BigDecimal;

public class SecurityConfiguration {
    @SerializedName("inspect_suspicious_login_after")
    private Period inspectSuspiciousLoginAfter;

    @SerializedName("refund_percent_limit")
    private BigDecimal refundPercentLimit;

    @SerializedName("limit_charge_by_card_configuration")
    private LimitChargeByCardConfiguration limitChargeByCardConfiguration;

    public Period getInspectSuspiciousLoginAfter() {
        return inspectSuspiciousLoginAfter;
    }

    public BigDecimal getRefundPercentLimit() {
        return refundPercentLimit;
    }

    public LimitChargeByCardConfiguration getLimitChargeByCardConfiguration() {
        return limitChargeByCardConfiguration;
    }

    public SecurityConfiguration(Period inspectSuspiciousLoginAfter) {
        this.inspectSuspiciousLoginAfter = inspectSuspiciousLoginAfter;
    }
}
