package jp.gopay.sdk.models.errors;

/**
 * Exceptions that result from errors returned by the GoPay API.
 */
public class GoPayException extends Exception {

    final int httpStatusCode;
    final String httpStatusMessage;
    final GoPayErrorBody body;

    public GoPayException(int code, String message, GoPayErrorBody body) {
        this.httpStatusCode = code;
        this.httpStatusMessage = message;
        this.body = body;
    }

    public int getHttpStatusCode() {
        return httpStatusCode;
    }

    public String getHttpStatusMessage() {
        return httpStatusMessage;
    }

    public GoPayErrorBody getBody() {
        return body;
    }

    @Override
    public String toString() {
        return getClass().getName() +
                "{ " +
                "HTTPStatus: " + httpStatusCode + " " + httpStatusMessage + ", " +
                "GoPayError: " + (body != null ? body.toString() : "null") +
                "}";
    }
}
