package jp.gopay.sdk.models.request.charge;

import com.google.gson.annotations.SerializedName;
import jp.gopay.sdk.models.common.MoneyLike;
import jp.gopay.sdk.models.common.TransactionTokenId;
import jp.gopay.sdk.types.MetadataMap;

import java.math.BigInteger;
import java.util.Date;
import java.util.UUID;

@SuppressWarnings("FieldCanBeLocal")
public class ChargesReq {
    @SerializedName("transaction_token_id")
    private UUID transactionTokenId;

    @SerializedName("amount")
    private BigInteger amount;

    @SerializedName("currency")
    private String currency;

    @SerializedName("capture")
    private Boolean capture;

    @SerializedName("capture_at")
    private Date captureAt;

    @SerializedName("metadata")
    private MetadataMap metadata;

    public ChargesReq(TransactionTokenId transactionTokenId, MoneyLike money, Boolean capture, Date captureAt, MetadataMap metadata) {
        this.transactionTokenId = transactionTokenId.toUUID();
        this.amount = money.getAmount();
        this.currency = money.getCurrency();
        this.capture = capture;
        this.captureAt = captureAt;
        this.metadata = metadata;
    }
}
