package jp.gopay.sdk.models.request.subscription;

import com.google.gson.annotations.SerializedName;
import jp.gopay.sdk.models.common.MoneyLike;
import jp.gopay.sdk.models.common.TransactionTokenId;
import jp.gopay.sdk.models.response.subscription.ScheduleSettings;
import jp.gopay.sdk.types.MetadataMap;
import jp.gopay.sdk.types.SubscriptionPeriod;

import java.math.BigInteger;
import java.util.Date;

public class SubscriptionCreateData extends SubscriptionRequestData {

    @SerializedName("currency")
    private String currency;

    @SerializedName("amount")
    private BigInteger amount;

    public SubscriptionCreateData(TransactionTokenId transactionTokenId,
                                  SubscriptionPeriod period,
                                  BigInteger initialAmount,
                                  MetadataMap metadata,
                                  InstallmentPlanRequest installmentPlan,
                                  ScheduleSettings scheduleSettings,
                                  Date subsequentCyclesStart,
                                  MoneyLike money) {
        super(transactionTokenId, period, initialAmount, metadata, installmentPlan, scheduleSettings, subsequentCyclesStart);
        this.currency = money.getCurrency();
        this.amount = money.getAmount();
    }
}
