package jp.gopay.sdk.models.request.subscription;

import com.google.gson.annotations.SerializedName;
import jp.gopay.sdk.models.common.TransactionTokenId;
import jp.gopay.sdk.models.response.subscription.ScheduleSettings;
import jp.gopay.sdk.types.MetadataMap;
import jp.gopay.sdk.types.SubscriptionPeriod;

import java.math.BigInteger;
import java.util.Date;
import java.util.UUID;

public abstract class SubscriptionRequestData {

    @SerializedName("transaction_token_id")
    private UUID transactionTokenId;

    @SerializedName("period")
    private SubscriptionPeriod period;

    @SerializedName("initial_amount")
    private BigInteger initialAmount;

    @SerializedName("metadata")
    private MetadataMap metadata;

    @SerializedName("installment_plan")
    private InstallmentPlanRequest installmentPlan;

    @SerializedName("schedule_settings")
    private ScheduleSettings scheduleSettings;

    @SerializedName("subsequent_cycles_start")
    private Date subsequentCyclesStart;

    public SubscriptionRequestData(TransactionTokenId transactionTokenId, SubscriptionPeriod period, BigInteger initialAmount,
                                   MetadataMap metadata, InstallmentPlanRequest installmentPlan,
                                   ScheduleSettings scheduleSettings, Date subsequentCyclesStart
    ) {
        if(transactionTokenId != null){
            this.transactionTokenId = transactionTokenId.toUUID();
        }
        this.period = period;
        this.initialAmount = initialAmount;
        this.metadata = metadata;
        this.installmentPlan = installmentPlan;
        this.scheduleSettings = scheduleSettings;
        this.subsequentCyclesStart = subsequentCyclesStart;
    }

    public TransactionTokenId getTransactionTokenId() {
        return new TransactionTokenId(transactionTokenId);
    }

    public SubscriptionPeriod getPeriod() {
        return period;
    }

    public BigInteger getInitialAmount() {
        return initialAmount;
    }

    public MetadataMap getMetadata() {
        return metadata;
    }

    public InstallmentPlanRequest getInstallmentPlan() {
        return installmentPlan;
    }

    public ScheduleSettings getScheduleSettings() {
        return scheduleSettings;
    }

    public Date getSubsequentCyclesStart() {
        return subsequentCyclesStart;
    }
}
