package jp.gopay.sdk.models.request.subscription;

import com.google.gson.annotations.SerializedName;
import jp.gopay.sdk.models.common.TransactionTokenId;
import jp.gopay.sdk.models.response.subscription.ScheduleSettings;
import jp.gopay.sdk.types.MetadataMap;
import jp.gopay.sdk.types.SubscriptionPeriod;
import jp.gopay.sdk.types.SubscriptionStatus;

import java.math.BigInteger;
import java.util.Date;

public class SubscriptionUpdateData extends SubscriptionRequestData{

    @SerializedName("status")
    SubscriptionStatus status;

    public SubscriptionUpdateData(TransactionTokenId transactionTokenId,
                                  SubscriptionPeriod period,
                                  BigInteger initialAmount,
                                  MetadataMap metadata,
                                  InstallmentPlanRequest installmentPlan,
                                  ScheduleSettings scheduleSettings,
                                  Date subsequentCyclesStart,
                                  SubscriptionStatus status) {
        super(transactionTokenId,
                period,
                initialAmount,
                metadata,
                installmentPlan,
                scheduleSettings,
                subsequentCyclesStart);
        this.status = status;
    }
}
