package jp.gopay.sdk.models.request.transactiontoken;

import com.google.gson.annotations.SerializedName;
import jp.gopay.sdk.types.MetadataMap;
import jp.gopay.sdk.types.PaymentTypeName;
import jp.gopay.sdk.types.RecurringTokenInterval;
import jp.gopay.sdk.types.TransactionTokenType;

@SuppressWarnings("FieldCanBeLocal")
public class CreateReq {
    @SerializedName("payment_type")
    private PaymentTypeName paymentType;

    @SerializedName("email")
    private String email;

    @SerializedName("type")
    private TransactionTokenType type;

    @SerializedName("usage_limit")
    private RecurringTokenInterval usageLimit;

    @SerializedName("metadata")
    private MetadataMap metadata;

    @SerializedName("data")
    private PaymentData data;

    public CreateReq(String email, TransactionTokenType type, RecurringTokenInterval usageLimit, MetadataMap metadata, PaymentData data) {
        this.paymentType = data.getPaymentType();
        this.email = email;
        this.type = type;
        this.usageLimit = usageLimit;
        this.metadata = metadata;
        this.data = data;
    }
}
