package jp.gopay.sdk.models.request.transactiontoken;

import com.google.gson.annotations.SerializedName;
import jp.gopay.sdk.models.common.TransactionTokenId;
import jp.gopay.sdk.types.MetadataMap;

import java.util.Date;
import java.util.UUID;

public class TemporaryTokenAliasReq {

    @SerializedName("transaction_token_id")
    private UUID transactionTokenId;

    @SerializedName("valid_until")
    private Date validUntil;

    @SerializedName("metadata")
    private MetadataMap metadata;

    public UUID getTransactionTokenId() {
        return transactionTokenId;
    }

    public Date getValidUntil() {
        return validUntil;
    }

    public MetadataMap getMetadata() {
        return metadata;
    }

    public TemporaryTokenAliasReq(TransactionTokenId transactionTokenId, Date validUntil, MetadataMap metadata) {
        this.transactionTokenId = transactionTokenId.toUUID();
        this.validUntil = validUntil;
        this.metadata = metadata;
    }
}

