package jp.gopay.sdk.models.response.applicationtoken;

import com.google.gson.annotations.SerializedName;
import jp.gopay.sdk.models.common.AppJWTId;
import jp.gopay.sdk.models.common.MerchantId;
import jp.gopay.sdk.models.response.GoPayResponse;
import jp.gopay.sdk.models.response.SimpleModel;

import java.util.Date;
import java.util.UUID;

public abstract class ApplicationJWT extends GoPayResponse implements SimpleModel<AppJWTId> {

    @SerializedName("merchant_id")
    private UUID merchantId;

    @SerializedName("creator_id")
    private UUID creatorId;

    @SerializedName("jti")
    private UUID jti;

    @SerializedName("secret")
    private String secret;

    @SerializedName("jwt")
    private String jwt;

    @SerializedName("created_on")
    private Date createdOn;

    public MerchantId getMerchantId() {
        return new MerchantId(merchantId);
    }

    public MerchantId getCreatorId() {
        return new MerchantId(creatorId);
    }

    public AppJWTId getId() {
        return new AppJWTId(jti);
    }

    public String getSecret() {
        return secret;
    }

    public String getJwt() {
        return jwt;
    }

    public Date getCreatedOn() {
        return createdOn;
    }
}
