package jp.gopay.sdk.models.response.authentication;

import com.google.gson.annotations.SerializedName;
import jp.gopay.sdk.models.common.MerchantId;
import jp.gopay.sdk.models.common.auth.LoginJWTStrategy;
import jp.gopay.sdk.models.common.auth.LoginTokenStrategy;
import jp.gopay.sdk.models.response.GoPayResponse;

import java.util.UUID;


public class LoginTokenInfo extends GoPayResponse {
    @SerializedName("jwt")
    private LoginJWTStrategy jwt;

    @SerializedName("token")
    private String token;

    @SerializedName("merchant_id")
    private UUID merchantId;

    public LoginJWTStrategy getJWTAuthStrategy() {
        return jwt;
    }

    public String getToken() {
        return token;
    }

    public LoginTokenStrategy getLoginTokenAuthStrategy(){
        return new LoginTokenStrategy(token);
    }

    public MerchantId getMerchantId() {
        return new MerchantId(merchantId);
    }

}
