package jp.gopay.sdk.models.response.cancel;

import com.google.gson.annotations.SerializedName;
import jp.gopay.sdk.models.common.CancelId;
import jp.gopay.sdk.models.common.ChargeId;
import jp.gopay.sdk.models.common.StoreId;
import jp.gopay.sdk.models.response.GoPayResponse;
import jp.gopay.sdk.models.response.PaymentError;
import jp.gopay.sdk.models.response.SimpleModel;
import jp.gopay.sdk.types.CancelStatus;
import jp.gopay.sdk.types.MetadataMap;
import jp.gopay.sdk.types.ProcessingMode;
import jp.gopay.sdk.utils.MetadataAdapter;

import java.util.Date;
import java.util.UUID;

public class Cancel extends GoPayResponse implements SimpleModel<CancelId> {

    @SerializedName("id")
    private UUID cancelId;

    @SerializedName("charge_id")
    private UUID chargeId;

    @SerializedName("store_id")
    private UUID storeId;

    @SerializedName("status")
    private CancelStatus cancelStatus;

    @SerializedName("error")
    private PaymentError error;

    @SerializedName("metadata")
    private MetadataMap metadata;

    @SerializedName("mode")
    private ProcessingMode mode;

    @SerializedName("created_on")
    private Date createdOn;

    public CancelId getCancelId() {
        return new CancelId(cancelId);
    }

    public ChargeId getChargeId() {
        return new ChargeId(chargeId);
    }

    public StoreId getStoreId() {
        return new StoreId(storeId);
    }

    public CancelStatus getCancelStatus() {
        return cancelStatus;
    }

    public PaymentError getError() {
        return error;
    }

    public MetadataMap getMetadata() {
        return metadata;
    }

    public <T> T getMetadata(MetadataAdapter<T> deserializer) {
        return deserializer.deserialize(metadata);
    }

    public ProcessingMode getMode() {
        return mode;
    }

    public Date getCreatedOn() {
        return createdOn;
    }

    @Override
    public CancelId getId() {
        return new CancelId(cancelId);
    }
}
