package jp.gopay.sdk.models.response.charge;

import com.google.gson.annotations.SerializedName;
import jp.gopay.sdk.models.common.ChargeId;
import jp.gopay.sdk.models.common.StoreId;
import jp.gopay.sdk.models.common.SubscriptionId;
import jp.gopay.sdk.models.common.TransactionTokenId;
import jp.gopay.sdk.models.response.GoPayResponse;
import jp.gopay.sdk.models.response.PaymentError;
import jp.gopay.sdk.models.response.SimpleModel;
import jp.gopay.sdk.types.ChargeStatus;
import jp.gopay.sdk.types.MetadataMap;
import jp.gopay.sdk.types.ProcessingMode;
import jp.gopay.sdk.types.TransactionTokenType;
import jp.gopay.sdk.utils.MetadataAdapter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.UUID;


public class Charge extends GoPayResponse implements SimpleModel<ChargeId> {
    @SerializedName("id")
    private UUID id;

    @SerializedName("store_id")
    private UUID storeId;

    @SerializedName("transaction_token_id")
    private UUID transactionTokenId;
    
    @SerializedName("transaction_token_type")
    private TransactionTokenType transactionTokenType;

    @SerializedName("subscription_id")
    private UUID subscriptionId;

    @SerializedName("requested_amount")
    private BigInteger requestedAmount;

    @SerializedName("requested_currency")
    private String requestedCurrency;

    @SerializedName("requested_amount_formatted")
    private BigDecimal requestedAmountFormatted;

    @SerializedName("charged_amount")
    private BigInteger chargedAmount;

    @SerializedName("charged_currency")
    private String chargedCurrency;

    @SerializedName("charged_amount_formatted")
    private BigDecimal chargedAmountFormatted;

    @SerializedName("capture_at")
    private Date captureAt;
    
    @SerializedName("status")
    private ChargeStatus status;

    @SerializedName("error")
    private PaymentError error;

    @SerializedName("metadata")
    private MetadataMap metadata;

    @SerializedName("mode")
    private ProcessingMode mode;

    @SerializedName("created_on")
    private Date createdOn;

    public ChargeId getId() {
        return new ChargeId(id);
    }

    public StoreId getStoreId() {
        return new StoreId(storeId);
    }

    public TransactionTokenId getTransactionTokenId() {
        return new TransactionTokenId(transactionTokenId);
    }

    public TransactionTokenType getTransactionTokenType() {
        return transactionTokenType;
    }

    public SubscriptionId getSubscriptionId() {
        return new SubscriptionId(subscriptionId);
    }

    public BigInteger getRequestedAmount() {
        return requestedAmount;
    }

    public String getRequestedCurrency() {
        return requestedCurrency;
    }

    public BigDecimal getRequestedAmountFormatted() {
        return requestedAmountFormatted;
    }

    public BigInteger getChargedAmount() {
        return chargedAmount;
    }

    public String getChargedCurrency() {
        return chargedCurrency;
    }

    public BigDecimal getChargedAmountFormatted() {
        return chargedAmountFormatted;
    }

    public Date getCaptureAt() {
        return captureAt;
    }

    public ChargeStatus getStatus() {
        return status;
    }

    public PaymentError getError() {
        return error;
    }

    public MetadataMap getMetadata() {
        return metadata;
    }

    public <T> T getMetadata(MetadataAdapter<T> deserializer) {
        return deserializer.deserialize(metadata);
    }

    public ProcessingMode getMode() {
        return mode;
    }

    public Date getCreatedOn() {
        return createdOn;
    }
}
