package jp.gopay.sdk.models.response.configuration;

import com.google.gson.annotations.SerializedName;
import jp.gopay.sdk.models.common.*;
import jp.gopay.sdk.models.common.stores.SecurityConfiguration;
import jp.gopay.sdk.models.response.store.CardConfiguration;
import jp.gopay.sdk.models.response.store.QrScanConfiguration;
import jp.gopay.sdk.models.response.store.RecurringTokenConfiguration;
import jp.gopay.sdk.models.response.subscription.SubscriptionConfiguration;
import jp.gopay.sdk.types.CardBrand;
import jp.gopay.sdk.types.Country;
import org.threeten.bp.ZoneId;

import javax.annotation.Nullable;
import java.math.BigDecimal;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class Configuration {

    @SerializedName("percent_fee")
    private BigDecimal percentFee;

    @SerializedName("flat_fees")
    private List<FlatFee> flatFees;

    @SerializedName("logo_url")
    private URL logoUrl;

    @SerializedName("country")
    private Country country;

    @SerializedName("language")
    private Locale language;

    @SerializedName("min_transfer_payout")
    private MoneyLike minTransferPayout;

    @SerializedName("maximum_charge_amounts")
    private List<MoneyLike> maximumChargeAmounts;

    @SerializedName("transfer_schedule")
    private TransferScheduleConfiguration transferScheduleConfiguration;

    @SerializedName("display_time_zone")
    private ZoneId timeZone;

    @SerializedName("user_transactions_configuration")
    private UserTransactionsConfiguration userTransactionsConfiguration;

    @SerializedName("card_configuration")
    private CardConfiguration cardConfiguration;

    @SerializedName("qr_scan_configuration")
    private QrScanConfiguration qrScanConfiguration;

    @SerializedName("convenience_configuration")
    private KonbiniConfiguration convenienceConfiguration;

    @SerializedName("recurring_token_configuration")
    private RecurringTokenConfiguration recurringConfiguration;

    @SerializedName("security_configuration")
    private SecurityConfiguration securityConfiguration;

    @SerializedName("installments_configuration")
    private InstallmentsConfiguration installmentsConfiguration;

    @SerializedName("card_brand_percent_fees")
    private Map<CardBrand, BigDecimal> cardBrandPercentFees;

    @SerializedName("subscription_configuration")
    private SubscriptionConfiguration subscriptionConfiguration;

    public BigDecimal getPercentFee() {
        return percentFee;
    }

    public List<FlatFee> getFlatFees() {
        return flatFees;
    }

    public URL getLogoUrl() {
        return logoUrl;
    }

    /**
     * The returned type will be changed to {@link Country} on later release
     * @return country
     */
    public String getCountry() {
        if(country == null){
            return null;
        }

        return country.getAlpha2();
    }

    /**
     * This method will be deleted when the returned type by "getCountry(String)" is changed to {@link Country}
     * @return country enum
     */
    public Country getCountryEnum() {
        return country;
    }

    public Locale getLanguage() {
        return language;
    }

    public MoneyLike getMinTransferPayout() {
        return minTransferPayout;
    }

    public List<MoneyLike> getMaximumChargeAmounts() {
        return maximumChargeAmounts;
    }

    public TransferScheduleConfiguration getTransferScheduleConfiguration() {
        return transferScheduleConfiguration;
    }

    public ZoneId getTimeZone() {
        return timeZone;
    }

    public UserTransactionsConfiguration getUserTransactionsConfiguration() {
        return userTransactionsConfiguration;
    }

    public CardConfiguration getCardConfiguration() {
        return cardConfiguration;
    }

    public QrScanConfiguration getQrScanConfiguration() {
        return qrScanConfiguration;
    }

    public RecurringTokenConfiguration getRecurringConfiguration() {
        return recurringConfiguration;
    }

    public SecurityConfiguration getSecurityConfiguration() {
        return securityConfiguration;
    }

    public InstallmentsConfiguration getInstallmentsConfiguration() {
        return installmentsConfiguration;
    }

    public Map<CardBrand, BigDecimal> getCardBrandPercentFees() {
        return cardBrandPercentFees;
    }

    public KonbiniConfiguration getConvenienceConfiguration() {
        return convenienceConfiguration;
    }

    public SubscriptionConfiguration getSubscriptionConfiguration() {
        return subscriptionConfiguration;
    }

    public Configuration(@Nullable BigDecimal percentFee,
                         @Nullable List<FlatFee> flatFees,
                         @Nullable URL logoUrl,
                         @Nullable Country country,
                         @Nullable Locale language,
                         @Nullable MoneyLike minTransferPayout,
                         @Nullable List<MoneyLike> maximumChargeAmounts,
                         @Nullable TransferScheduleConfiguration transferScheduleConfiguration,
                         @Nullable ZoneId timeZone,
                         @Nullable UserTransactionsConfiguration userTransactionsConfiguration,
                         @Nullable CardConfiguration cardConfiguration,
                         @Nullable QrScanConfiguration qrScanConfiguration,
                         @Nullable KonbiniConfiguration convenienceConfiguration,
                         @Nullable RecurringTokenConfiguration recurringConfiguration,
                         @Nullable SecurityConfiguration securityConfiguration,
                         @Nullable Map<CardBrand, BigDecimal> cardBrandPercentFees,
                         @Nullable InstallmentsConfiguration installmentsConfiguration,
                         @Nullable SubscriptionConfiguration subscriptionConfiguration) {
        this.percentFee = percentFee;
        this.flatFees = flatFees;
        this.logoUrl = logoUrl;
        this.country = country;
        this.language = language;
        this.minTransferPayout = minTransferPayout;
        this.maximumChargeAmounts = maximumChargeAmounts;
        this.transferScheduleConfiguration = transferScheduleConfiguration;
        this.timeZone = timeZone;
        this.userTransactionsConfiguration = userTransactionsConfiguration;
        this.cardConfiguration = cardConfiguration;
        this.qrScanConfiguration = qrScanConfiguration;
        this.convenienceConfiguration = convenienceConfiguration;
        this.recurringConfiguration = recurringConfiguration;
        this.securityConfiguration = securityConfiguration;
        this.cardBrandPercentFees = cardBrandPercentFees;
        this.installmentsConfiguration = installmentsConfiguration;
        this.subscriptionConfiguration = subscriptionConfiguration;
    }

    public Configuration(){}

}
