package jp.gopay.sdk.models.response.merchant;

import jp.gopay.sdk.models.common.*;
import jp.gopay.sdk.models.common.stores.SecurityConfiguration;
import jp.gopay.sdk.models.response.configuration.Configuration;
import jp.gopay.sdk.models.response.store.CardConfiguration;
import jp.gopay.sdk.models.response.store.QrScanConfiguration;
import jp.gopay.sdk.models.response.store.RecurringTokenConfiguration;
import jp.gopay.sdk.models.response.subscription.SubscriptionConfiguration;
import jp.gopay.sdk.types.CardBrand;
import jp.gopay.sdk.types.Country;
import org.threeten.bp.ZoneId;

import javax.annotation.Nullable;
import java.math.BigDecimal;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class MerchantConfiguration extends Configuration {

    public MerchantConfiguration(@Nullable BigDecimal percentFee,
                                 @Nullable List<FlatFee> flatFees,
                                 @Nullable URL logoUrl,
                                 @Nullable Country country,
                                 @Nullable Locale language,
                                 @Nullable MoneyLike minTransferPayout,
                                 @Nullable List<MoneyLike> maximumChargeAmounts,
                                 @Nullable TransferScheduleConfiguration transferScheduleConfiguration,
                                 @Nullable ZoneId timeZone,
                                 @Nullable UserTransactionsConfiguration userTransactionsConfiguration,
                                 @Nullable CardConfiguration cardConfiguration,
                                 @Nullable QrScanConfiguration qrScanConfiguration,
                                 @Nullable KonbiniConfiguration convenienceConfiguration,
                                 @Nullable RecurringTokenConfiguration recurringConfiguration,
                                 @Nullable SecurityConfiguration securityConfiguration,
                                 @Nullable Map<CardBrand, BigDecimal> cardBrandPercentFees,
                                 @Nullable InstallmentsConfiguration installmentsConfiguration,
                                 @Nullable SubscriptionConfiguration subscriptionSettings) {
        super(percentFee,
                flatFees,
                logoUrl,
                country,
                language,
                minTransferPayout,
                maximumChargeAmounts,
                transferScheduleConfiguration,
                timeZone,
                userTransactionsConfiguration,
                cardConfiguration,
                qrScanConfiguration,
                convenienceConfiguration,
                recurringConfiguration,
                securityConfiguration,
                cardBrandPercentFees,
                installmentsConfiguration,
                subscriptionSettings);
    }
}
