package jp.gopay.sdk.models.response.merchant;

import com.google.gson.annotations.SerializedName;
import jp.gopay.sdk.models.common.ChargeId;
import jp.gopay.sdk.models.common.ResourceId;
import jp.gopay.sdk.models.common.StoreId;
import jp.gopay.sdk.models.response.SimpleModel;
import jp.gopay.sdk.types.MetadataMap;
import jp.gopay.sdk.types.ProcessingMode;
import jp.gopay.sdk.types.TransactionStatus;
import jp.gopay.sdk.types.TransactionType;
import jp.gopay.sdk.utils.MetadataAdapter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.UUID;


public class Transaction implements SimpleModel<ResourceId> {

    @SerializedName("store_id")
    private UUID storeId;

    @SerializedName("resource_id")
    private UUID resourceId;

    @SerializedName("charge_id")
    private UUID chargeId;

    @SerializedName("amount")
    private BigInteger amount;

    @SerializedName("currency")
    private String currency;

    @SerializedName("amount_formatted")
    private BigDecimal amountFormatted;

    @SerializedName("type")
    private TransactionType transactionType;

    @SerializedName("status")
    private TransactionStatus status;

    @SerializedName("metadata")
    private MetadataMap metadata;

    @SerializedName("created_on")
    private Date createdOn;

    @SerializedName("mode")
    private ProcessingMode mode;

    public StoreId getStoreId() {
        return new StoreId(storeId);
    }

    public ResourceId getResourceId() {
        return new ResourceId(resourceId);
    }

    public ChargeId getChargeId() {
        return new ChargeId(chargeId);
    }

    public BigInteger getAmount() {
        return amount;
    }

    public String getCurrency() {
        return currency;
    }

    public BigDecimal getAmountFormatted() {
        return amountFormatted;
    }

    public TransactionType getTransactionType() {
        return transactionType;
    }

    public TransactionStatus getStatus() {
        return status;
    }

    public MetadataMap getMetadata() {
        return metadata;
    }

    public <T> T getMetadata(MetadataAdapter<T> deserializer) {
        return deserializer.deserialize(metadata);
    }

    public Date getCreatedOn() {
        return createdOn;
    }

    public ProcessingMode getMode() {
        return mode;
    }

    @Override
    public ResourceId getId() {
        return new ResourceId(resourceId);
    }
}
