package jp.gopay.sdk.models.response.refund;

import com.google.gson.annotations.SerializedName;
import jp.gopay.sdk.models.common.ChargeId;
import jp.gopay.sdk.models.common.RefundId;
import jp.gopay.sdk.models.common.StoreId;
import jp.gopay.sdk.models.response.GoPayResponse;
import jp.gopay.sdk.models.response.PaymentError;
import jp.gopay.sdk.models.response.SimpleModel;
import jp.gopay.sdk.types.MetadataMap;
import jp.gopay.sdk.types.ProcessingMode;
import jp.gopay.sdk.types.RefundReason;
import jp.gopay.sdk.types.RefundStatus;
import jp.gopay.sdk.utils.MetadataAdapter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.UUID;


public class Refund extends GoPayResponse implements SimpleModel<RefundId> {
    @SerializedName("id")
    private UUID id;

    @SerializedName("store_id")
    private UUID storeId;

    @SerializedName("charge_id")
    private UUID chargeId;

    @SerializedName("status")
    private RefundStatus status;

    @SerializedName("amount")
    private BigInteger amount;

    @SerializedName("currency")
    private String currency;

    @SerializedName("amount_formatted")
    private BigDecimal amountFormatted;

    @SerializedName("reason")
    private RefundReason reason;

    @SerializedName("message")
    private String message;

    @SerializedName("error")
    private PaymentError error;

    @SerializedName("metadata")
    private MetadataMap metadata;

    @SerializedName("mode")
    private ProcessingMode mode;

    @SerializedName("created_on")
    private Date createdOn;

    public RefundId getId() {
        return new RefundId(id);
    }

    public ChargeId getChargeId() {
        return new ChargeId(chargeId);
    }

    public RefundStatus getStatus() {
        return status;
    }

    public BigInteger getAmount() {
        return amount;
    }

    public String getCurrency() {
        return currency;
    }

    public RefundReason getReason() {
        return reason;
    }

    public String getMessage() {
        return message;
    }

    public PaymentError getError() {
        return error;
    }

    public MetadataMap getMetadata() {
        return metadata;
    }

    public <T> T getMetadata(MetadataAdapter<T> deserializer) {
        return deserializer.deserialize(metadata);
    }

    public ProcessingMode getMode() {
        return mode;
    }

    public StoreId getStoreId() {
        return new StoreId(storeId);
    }

    public BigDecimal getAmountFormatted() {
        return amountFormatted;
    }

    public Date getCreatedOn() {
        return createdOn;
    }
}
