package jp.gopay.sdk.models.response.store;

import com.google.gson.annotations.SerializedName;
import jp.gopay.sdk.models.common.KonbiniConfiguration;
import jp.gopay.sdk.models.common.RecurringTokenCVVConfirmation;
import jp.gopay.sdk.models.response.GoPayResponse;
import jp.gopay.sdk.types.ProcessingMode;
import jp.gopay.sdk.types.RecurringTokenPrivilege;

import java.net.URL;

public class CheckoutInfo extends GoPayResponse{
    @SerializedName("mode")
    private ProcessingMode mode;

    @SerializedName("recurring_token_privilege")
    private RecurringTokenPrivilege recurringTokenPrivilege;

    @SerializedName("name")
    private String name;

    @SerializedName("card_configuration")
    private CardConfiguration cardConfiguration;

    @SerializedName("qr_scan_configuration")
    private QrScanConfiguration qrScanConfiguration;

    @SerializedName("convenience_configuration")
    private KonbiniConfiguration konbiniConfiguration;

    @SerializedName("logo_image")
    private URL logoImage;

    @SerializedName("theme")
    private WidgetConfiguration theme;

    @SerializedName("recurring_card_charge_cvv_confirmation")
    private RecurringTokenCVVConfirmation recurringTokenCVVConfirmation;

    public ProcessingMode getMode() {
        return mode;
    }

    public RecurringTokenPrivilege getRecurringTokenPrivilege() {
        return recurringTokenPrivilege;
    }

    public CardConfiguration getCardConfiguration() {
        return cardConfiguration;
    }

    public QrScanConfiguration getQrScanConfiguration() {
        return qrScanConfiguration;
    }

    public KonbiniConfiguration getKonbiniConfiguration() {
        return konbiniConfiguration;
    }

    public String getName() {
        return name;
    }

    public URL getLogoImage() {
        return logoImage;
    }

    public WidgetConfiguration getTheme() {
        return theme;
    }

    public RecurringTokenCVVConfirmation getRecurringTokenCVVConfirmation() {
        return recurringTokenCVVConfirmation;
    }
}
