package jp.gopay.sdk.models.response.subscription;

import com.google.gson.annotations.SerializedName;
import jp.gopay.sdk.models.common.StoreId;
import jp.gopay.sdk.models.common.SubscriptionId;
import jp.gopay.sdk.models.response.GoPayResponse;
import jp.gopay.sdk.models.response.SimpleModel;
import jp.gopay.sdk.types.MetadataMap;
import jp.gopay.sdk.types.ProcessingMode;
import jp.gopay.sdk.types.SubscriptionPeriod;
import jp.gopay.sdk.types.SubscriptionStatus;
import jp.gopay.sdk.utils.MetadataAdapter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.UUID;


public class Subscription extends GoPayResponse implements SimpleModel<SubscriptionId> {
    @SerializedName("id")
    private UUID id;

    @SerializedName("store_id")
    private UUID storeId;

    @SerializedName("transaction_token_id")
    private UUID transactionTokenId;

    @SerializedName("amount")
    private BigInteger amount;

    @SerializedName("currency")
    private String currency;

    @SerializedName("amount_formatted")
    private BigDecimal amountFormatted;

    @SerializedName("period")
    private SubscriptionPeriod period;

    @SerializedName("initial_amount")
    private BigInteger initialAmount;

    @SerializedName("initial_amount_formatted")
    private BigDecimal initialAmountFormatted;

    @SerializedName("subsequent_cycles_start")
    private Date subsequentCyclesStart;

    @SerializedName("schedule_settings")
    private ScheduleSettings scheduleSettings;

    @SerializedName("status")
    private SubscriptionStatus status;

    @SerializedName("metadata")
    private MetadataMap metadata;

    @SerializedName("mode")
    private ProcessingMode mode;

    @SerializedName("created_on")
    private Date createdOn;

    public SubscriptionId getId() {
        return new SubscriptionId(id);
    }

    public StoreId getStoreId() {
        return new StoreId(storeId);
    }

    public UUID getTransactionTokenId() {
        return transactionTokenId;
    }

    public BigInteger getAmount() {
        return amount;
    }

    public String getCurrency() {
        return currency;
    }

    public BigDecimal getAmountFormatted() {
        return amountFormatted;
    }

    public SubscriptionPeriod getPeriod() {
        return period;
    }

    public BigInteger getInitialAmount() {
        return initialAmount;
    }

    public BigDecimal getInitialAmountFormatted() {
        return initialAmountFormatted;
    }

    public Date getSubsequentCyclesStart() {
        return subsequentCyclesStart;
    }

    public ScheduleSettings getScheduleSettings() {
        return scheduleSettings;
    }

    public SubscriptionStatus getStatus() {
        return status;
    }

    public MetadataMap getMetadata() {
        return metadata;
    }

    public <T> T getMetadata(MetadataAdapter<T> deserializer) {
        return deserializer.deserialize(metadata);
    }

    public ProcessingMode getMode() {
        return mode;
    }

    public Date getCreatedOn() {
        return createdOn;
    }

}
