package jp.gopay.sdk.models.response.transactiontoken;

import com.google.gson.annotations.SerializedName;
import jp.gopay.sdk.types.Konbini;
import org.joda.time.Period;


public class PaymentData {

    @SerializedName("card")
    private TransactionTokenCardData card;

    @SerializedName("billing")
    private TransactionTokenBillingData billing;

    @SerializedName("customer_name")
    private String customerName;

    @SerializedName("convenience_store")
    private Konbini convenienceStore;

    @SerializedName("expiration_period")
    private Period expirationPeriod;

    @SerializedName("phone_number")
    private PhoneNumber phoneNumber;

    public TransactionTokenCardData getCard() {
        return card;
    }

    public TransactionTokenBillingData getBilling() {
        return billing;
    }

    public String getCustomerName() {
        return customerName;
    }

    public Konbini getConvenienceStore() {
        return convenienceStore;
    }

    public Period getExpirationPeriod() {
        return expirationPeriod;
    }

    public PhoneNumber getPhoneNumber() {
        return phoneNumber;
    }

    public CardPaymentData asCardPaymentData(){
        return new CardPaymentData(card, billing);
    }

    public KonbiniPaymentData asKonbiniPaymentData(){
        return new KonbiniPaymentData(customerName, convenienceStore, expirationPeriod, phoneNumber);
    }

    public QrScanPaymentData asQrScanData(){
        return new QrScanPaymentData();
    }
}
