package jp.gopay.sdk.models.response.transactiontoken;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import jp.gopay.sdk.models.common.MerchantId;
import jp.gopay.sdk.models.common.StoreId;
import jp.gopay.sdk.models.common.TemporaryTokenAliasId;
import jp.gopay.sdk.models.common.TransactionTokenId;
import jp.gopay.sdk.models.response.GoPayResponse;
import jp.gopay.sdk.models.response.SimpleModel;
import jp.gopay.sdk.types.MetadataMap;
import jp.gopay.sdk.utils.RequestUtils;

import java.util.Date;
import java.util.UUID;

public class TemporaryTokenAlias extends GoPayResponse implements SimpleModel<TemporaryTokenAliasId> {

    @SerializedName("id")
    private UUID id;

    @SerializedName("transaction_token_id")
    UUID transactionTokenId;

    @SerializedName("merchant_id")
    UUID merchantId;

    @SerializedName("store_id")
    UUID storeId;

    @SerializedName("active")
    Boolean active;

    @SerializedName("valid_until")
    Date validUntil;

    @SerializedName("metadata")
    MetadataMap metadata;

    @SerializedName("created_on")
    Date createdOn;

    @Override
    public TemporaryTokenAliasId getId() {
        if(id == null){
            return null;
        } else return new TemporaryTokenAliasId(id);
    }

    public TransactionTokenId getTransactionTokenId() {
        return new TransactionTokenId(transactionTokenId);
    }

    public MerchantId getMerchantId() {
        return new MerchantId(merchantId);
    }

    public StoreId getStoreId() {
        return new StoreId(storeId);
    }

    public Boolean getActive() {
        return active;
    }

    public Date getValidUntil() {
        return validUntil;
    }

    public MetadataMap getMetadata() {
        return metadata;
    }

    public Date getCreatedOn() {
        return createdOn;
    }

    private static String ILLEGAL_STRING_ERROR = "The alias string must be formatted as a valid Json object.";
    private static String ILLEGAL_JSON_ERROR = "The alias must be formatted a valid Json object.";
    private static String CANT_PARSE_AS_ALIAS = "Could not parse data as a temporary token alias.";

    public static TemporaryTokenAlias parse(String aliasObjectString){
        TemporaryTokenAlias alias;
        try{
            alias = RequestUtils.getGson().fromJson(aliasObjectString, TemporaryTokenAlias.class);
        } catch(JsonSyntaxException convertionError){
            throw new IllegalArgumentException(ILLEGAL_STRING_ERROR);
        }

        if(isValidAlias(alias)){
            return alias;
        } else throw new IllegalArgumentException(CANT_PARSE_AS_ALIAS);
    }

    public static TemporaryTokenAlias parse(JsonObject aliasObjectJson){
        TemporaryTokenAlias alias;
        try{
            alias = RequestUtils.getGson().fromJson(aliasObjectJson, TemporaryTokenAlias.class);
        } catch(JsonSyntaxException convertionError){
            throw new IllegalArgumentException(ILLEGAL_JSON_ERROR);
        }

        if(isValidAlias(alias)){
            return alias;
        } else throw new IllegalArgumentException(CANT_PARSE_AS_ALIAS);
    }

    private static boolean isValidAlias(TemporaryTokenAlias alias){
        return (
                alias.getId() != null &&
                alias.getStoreId() != null &&
                alias.getValidUntil() != null
        );
    }
}
