package jp.gopay.sdk.models.response.transactiontoken;

import com.google.gson.annotations.SerializedName;
import jp.gopay.sdk.models.common.StoreId;
import jp.gopay.sdk.models.common.TransactionTokenId;
import jp.gopay.sdk.models.response.GoPayResponse;
import jp.gopay.sdk.models.response.SimpleModel;
import jp.gopay.sdk.types.*;
import jp.gopay.sdk.utils.MetadataAdapter;

import java.util.Date;
import java.util.UUID;

public class TransactionToken extends GoPayResponse implements SimpleModel<TransactionTokenId> {
    @SerializedName("id")
    private UUID id;

    @SerializedName("store_id")
    private UUID storeId;

    @SerializedName("email")
    private String email;

    @SerializedName("active")
    private Boolean active;

    @SerializedName("mode")
    private ProcessingMode mode;

    @SerializedName("type")
    private TransactionTokenType type;

    @SerializedName("usage_limit")
    private RecurringTokenInterval usageLimit;

    @SerializedName("created_on")
    private Date createdOn;

    @SerializedName("last_used_on")
    private Date lastUsedOn;

    @SerializedName("payment_type")
    private PaymentTypeName paymentTypeName;

    @SerializedName("metadata")
    private MetadataMap metadata;

    public TransactionTokenId getId() {
        return new TransactionTokenId(id);
    }

    public StoreId getStoreId() {
        return new StoreId(storeId);
    }

    public String getEmail() {
        return email;
    }

    public Boolean getActive() {
        return active;
    }

    public ProcessingMode getMode() {
        return mode;
    }

    public TransactionTokenType getType() {
        return type;
    }

    public Date getCreatedOn() {
        return createdOn;
    }

    public Date getLastUsedOn() {
        return lastUsedOn;
    }

    public PaymentTypeName getPaymentTypeName() {
        return paymentTypeName;
    }

    public RecurringTokenInterval getUsageLimit() {
        return usageLimit;
    }

    public MetadataMap getMetadata() {
        return metadata;
    }

    public <T> T getMetadata(MetadataAdapter<T> deserializer) {
        return deserializer.deserialize(metadata);
    }
}
