package jp.gopay.sdk.models.response.transfer;

import com.google.gson.annotations.SerializedName;
import jp.gopay.sdk.models.common.BankAccountId;
import jp.gopay.sdk.models.common.TransferId;
import jp.gopay.sdk.models.response.GoPayResponse;
import jp.gopay.sdk.models.response.SimpleModel;
import jp.gopay.sdk.types.MetadataMap;
import jp.gopay.sdk.types.TransferStatus;
import jp.gopay.sdk.utils.MetadataAdapter;
import org.joda.time.LocalDate;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.UUID;


public class Transfer extends GoPayResponse implements SimpleModel<TransferId> {
    @SerializedName("id")
    private UUID transferId;

    @SerializedName("bank_account_id")
    private UUID bankAccountId;

    @SerializedName("amount")
    private BigInteger amount;

    @SerializedName("currency")
    private String currency;

    @SerializedName("amount_formatted")
    private BigDecimal amountFormatted;

    @SerializedName("status")
    private TransferStatus status;

    @SerializedName("error_code")
    private String errorCode;

    @SerializedName("error_text")
    private String errorText;

    @SerializedName("metadata")
    private MetadataMap metadata;

    @SerializedName("note")
    private String note;

    @SerializedName("from")
    private LocalDate from;

    @SerializedName("to")
    private LocalDate to;

    @SerializedName("created_on")
    private Date createdOn;

    public TransferId getTransferId() {
        return new TransferId(transferId);
    }

    public BankAccountId getBankAccountId() {
        return new BankAccountId(bankAccountId);
    }

    public BigInteger getAmount() {
        return amount;
    }

    public String getCurrency() {
        return currency;
    }

    public BigDecimal getAmountFormatted() {
        return amountFormatted;
    }

    public TransferStatus getStatus() {
        return status;
    }

    public String getErrorCode() {
        return errorCode;
    }

    public String getErrorText() {
        return errorText;
    }

    public MetadataMap getMetadata() {
        return metadata;
    }

    public <T> T getMetadata(MetadataAdapter<T> deserializer) {
        return deserializer.deserialize(metadata);
    }

    public String getNote() {
        return note;
    }

    public LocalDate getFrom() {
        return from;
    }

    public LocalDate getTo() {
        return to;
    }

    public Date getCreatedOn() {
        return createdOn;
    }

    @Override
    public TransferId getId() {
        return new TransferId(transferId);
    }
}
