package jp.gopay.sdk.resources;

import jp.gopay.sdk.models.common.BankAccountId;
import jp.gopay.sdk.models.common.IdempotencyKey;
import jp.gopay.sdk.models.common.Void;
import jp.gopay.sdk.models.common.bankaccounts.BaseBankAccount;
import jp.gopay.sdk.models.request.bankaccount.BankAccountPatchData;
import jp.gopay.sdk.models.response.PaginatedList;
import jp.gopay.sdk.models.response.bankaccount.BankAccount;
import jp.gopay.sdk.types.CursorDirection;
import retrofit2.Call;
import retrofit2.http.*;

import javax.annotation.Nullable;

import static jp.gopay.sdk.constants.GopayConstants.idempotencyKeyHeaderName;

/**
 * Resource for managing a merchant's bank accounts.
 */

public interface BankAccountsResource {

    @GET("/bank_accounts")
    Call<PaginatedList<BankAccount>> list(
            @Query("limit") @Nullable Integer limit,
            @Query("cursor_direction") @Nullable CursorDirection cursorDirection,
            @Query("cursor") @Nullable BankAccountId cursor
    );

    @POST("/bank_accounts")
    Call<BankAccount> create(@Body BaseBankAccount dataToPost,
                             @Header(idempotencyKeyHeaderName) IdempotencyKey idempotencyKey
    );

    @GET("/bank_accounts/{bankAccountId}")
    Call<BankAccount> get(@Path("bankAccountId") BankAccountId bankAccountID);

    @PATCH("/bank_accounts/{bankAccountId}")
    Call<BankAccount> update(
            @Path("bankAccountId") BankAccountId bankAccountID,
            @Body BankAccountPatchData patchData,
            @Header(idempotencyKeyHeaderName) IdempotencyKey idempotencyKey
    );

    @DELETE("/bank_accounts/{bankAccountId}")
    Call<Void> delete(
            @Path("bankAccountId") BankAccountId bankAccountId
    );

    @GET("/bank_accounts/primary")
    Call<BankAccount> getPrimary();

}
