package jp.gopay.sdk.resources;

import jp.gopay.sdk.constants.GopayConstants;
import jp.gopay.sdk.models.common.CancelId;
import jp.gopay.sdk.models.common.ChargeId;
import jp.gopay.sdk.models.common.IdempotencyKey;
import jp.gopay.sdk.models.common.StoreId;
import jp.gopay.sdk.models.request.cancel.CancelCreateData;
import jp.gopay.sdk.models.request.cancel.CancelPatchData;
import jp.gopay.sdk.models.response.PaginatedList;
import jp.gopay.sdk.models.response.cancel.Cancel;
import jp.gopay.sdk.types.CursorDirection;
import retrofit2.Call;
import retrofit2.http.*;

import javax.annotation.Nullable;

public interface CancelResource {

    @GET("/stores/{storeId}/charges/{chargeId}/cancels")
    Call<PaginatedList<Cancel>> list(
            @Path("storeId") StoreId storeId,
            @Path("chargeId") ChargeId chargeId,
            @Query("limit") @Nullable Integer limit,
            @Query("cursor_direction") @Nullable CursorDirection cursorDirection,
            @Query("cursor") @Nullable CancelId cursor
    );

    @GET("/stores/{storeId}/charges/{chargeId}/cancels/{cancelId}")
    Call<Cancel> get(
            @Path("storeId") StoreId storeId,
            @Path("chargeId") ChargeId chargeId,
            @Path("cancelId") CancelId cancelId,
            @Query("polling") @Nullable Boolean polling
            );

    @POST("/stores/{storeId}/charges/{chargeId}/cancels")
    Call<Cancel> create(
            @Path("storeId") StoreId storeId,
            @Path("chargeId") ChargeId chargeId,
            @Body CancelCreateData requestBody,
            @Header(GopayConstants.idempotencyKeyHeaderName) IdempotencyKey idempotencyKey
            );

    @PATCH("/stores/{storeId}/charges/{chargeId}/cancels/{cancelId}")
    Call<Cancel> update(
            @Path("storeId") StoreId storeId,
            @Path("chargeId") ChargeId chargeId,
            @Path("cancelId") CancelId cancelId,
            @Body CancelPatchData requestBody,
            @Header(GopayConstants.idempotencyKeyHeaderName) IdempotencyKey idempotencyKey
            );
}
