package jp.gopay.sdk.resources;

import jp.gopay.sdk.constants.GopayConstants;
import jp.gopay.sdk.models.common.ChargeId;
import jp.gopay.sdk.models.common.IdempotencyKey;
import jp.gopay.sdk.models.common.StoreId;
import jp.gopay.sdk.models.common.Void;
import jp.gopay.sdk.models.request.charge.CaptureReq;
import jp.gopay.sdk.models.request.charge.ChargesReq;
import jp.gopay.sdk.models.request.charge.PatchReq;
import jp.gopay.sdk.models.response.PaginatedList;
import jp.gopay.sdk.models.response.charge.Charge;
import jp.gopay.sdk.types.CursorDirection;
import retrofit2.Call;
import retrofit2.http.*;

import javax.annotation.Nullable;
import java.util.Map;

public interface ChargesResource{

    @GET("/charges")
    Call<PaginatedList<Charge>> listAllCharges(
            @Query("limit") @Nullable Integer limit,
            @Query("cursor_direction") @Nullable CursorDirection cursorDirection,
            @Query("cursor") @Nullable ChargeId cursor,
            @QueryMap @Nullable Map<String, String> propertySearch,
            @Query("metadata") @Nullable String metadataSearch
    );

    @GET("/stores/{storeId}/charges")
    Call<PaginatedList<Charge>> listAllStoreCharges(
            @Path("storeId") StoreId storeId,
            @Query("limit") @Nullable Integer limit,
            @Query("cursor_direction") @Nullable CursorDirection cursorDirection,
            @Query("cursor") @Nullable ChargeId cursor,
            @QueryMap @Nullable Map<String, String> propertySearch,
            @Query("metadata") @Nullable String metadataSearch
    );

    @GET("/stores/{storeId}/charges/{id}")
    Call<Charge> getStoreCharge(
            @Path("storeId") StoreId storeId,
            @Path("id") ChargeId id,
            @Query("polling") @Nullable Boolean polling
    );

    @POST("/charges")
    Call<Charge> createCharge(
            @Body ChargesReq requestBody,
            @Header(GopayConstants.idempotencyKeyHeaderName) IdempotencyKey idempotencyKey
    );
    
    @PATCH("/stores/{storeId}/charges/{id}")
    Call<Charge> updateCharge(
            @Path("storeId") StoreId storeId,
            @Path("id") ChargeId id,
            @Body PatchReq requestBody,
            @Header(GopayConstants.idempotencyKeyHeaderName) IdempotencyKey idempotencyKey
    );
    
    @POST("/stores/{storeId}/charges/{id}/capture")
    Call<Void> capture(
            @Path("storeId") StoreId storeId,
            @Path("id") ChargeId id,
            @Body CaptureReq requestBody,
            @Header(GopayConstants.idempotencyKeyHeaderName) IdempotencyKey idempotencyKey
    );
    
}
