package jp.gopay.sdk.resources;

import jp.gopay.sdk.constants.GopayConstants;
import jp.gopay.sdk.models.common.IdempotencyKey;
import jp.gopay.sdk.models.common.MoneyLike;
import jp.gopay.sdk.models.request.exchangerate.ExchangeRateConversionReq;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.Header;
import retrofit2.http.POST;

public interface ExchangeRatesResource {

    @POST("/exchange_rates/calculate")
    Call<MoneyLike> convert(
            @Body ExchangeRateConversionReq dataToPost,
            @Header(GopayConstants.idempotencyKeyHeaderName) IdempotencyKey idempotencyKey
    );


}
