package jp.gopay.sdk.resources;

import jp.gopay.sdk.models.common.LedgerId;
import jp.gopay.sdk.models.common.TransferId;
import jp.gopay.sdk.models.response.PaginatedList;
import jp.gopay.sdk.models.response.ledger.Ledger;
import jp.gopay.sdk.types.CursorDirection;
import retrofit2.Call;
import retrofit2.http.GET;
import retrofit2.http.Path;
import retrofit2.http.Query;

import javax.annotation.Nullable;


/**
 * Resource for obtaining information about the ledgers associated with a transfer.
 */
public interface LedgersResource{

    @GET("/transfers/{transferId}/ledgers")
    Call<PaginatedList<Ledger>> listLedgers(
            @Path("transferId")TransferId transferId,
            @Query("all")Boolean all,
            @Query("from") String from,
            @Query("to") String to,
            @Query("min") Integer min,
            @Query("max") Integer max,
            @Query("currency") String currency,
            @Query("limit") @Nullable Integer limit,
            @Query("cursor_direction") @Nullable CursorDirection cursorDirection,
            @Query("cursor") @Nullable LedgerId cursor);
}
