package jp.gopay.sdk.resources;

import jp.gopay.sdk.models.common.IdempotencyKey;
import jp.gopay.sdk.models.common.ResourceId;
import jp.gopay.sdk.models.common.StoreId;
import jp.gopay.sdk.models.request.merchant.MerchantsReq;
import jp.gopay.sdk.models.response.PaginatedList;
import jp.gopay.sdk.models.response.merchant.MerchantVerificationData;
import jp.gopay.sdk.models.response.merchant.MerchantWithConfiguration;
import jp.gopay.sdk.models.response.merchant.Transaction;
import jp.gopay.sdk.types.CursorDirection;
import jp.gopay.sdk.types.ProcessingMode;
import jp.gopay.sdk.types.TransactionStatus;
import jp.gopay.sdk.types.TransactionType;
import retrofit2.Call;
import retrofit2.http.*;

import javax.annotation.Nullable;

import static jp.gopay.sdk.constants.GopayConstants.idempotencyKeyHeaderName;


/**
 * Resource for managing the merchant's information and history.
 */
public interface MerchantsResource{

    @GET("/verification")
    Call<MerchantVerificationData> getVerification();

    @POST("/verification")
    Call<MerchantVerificationData> createVerification(
            @Body MerchantsReq dataToPost,
            @Header(idempotencyKeyHeaderName) IdempotencyKey idempotencyKey
    );

    @PATCH("/verification")
    Call<MerchantVerificationData> updateVerification(
            @Body MerchantsReq dataToPatch,
            @Header(idempotencyKeyHeaderName) IdempotencyKey idempotencyKey
    );

    @GET("/transaction_history")
    Call<PaginatedList<Transaction>> getTransactionHistory(
            @Query("limit") @Nullable Integer limit,
            @Query("cursor_direction") @Nullable CursorDirection cursorDirection,
            @Query("cursor") @Nullable ResourceId cursor,
            @Query("from") @Nullable String from,
            @Query("to") @Nullable String to,
            @Query("status") @Nullable TransactionStatus status,
            @Query("type") @Nullable TransactionType type,
            @Query("mode") @Nullable ProcessingMode mode,
            @Query("search") @Nullable String search,
            @Query("all") @Nullable Boolean all
    );

    @GET("/stores/{storeId}/transaction_history")
    Call<PaginatedList<Transaction>> getStoreTransactionHistory(
            @Path("storeId") StoreId storeId,
            @Query("limit") @Nullable Integer limit,
            @Query("cursor_direction") @Nullable CursorDirection cursorDirection,
            @Query("cursor") @Nullable ResourceId cursor,
            @Query("from") @Nullable String from,
            @Query("to") @Nullable String to,
            @Query("status") @Nullable TransactionStatus status,
            @Query("type") @Nullable TransactionType type,
            @Query("mode") @Nullable ProcessingMode mode,
            @Query("search") @Nullable String search,
            @Query("all") @Nullable Boolean all
    );

    @GET("/me")
    Call<MerchantWithConfiguration> me();
}
