package jp.gopay.sdk.resources;

import jp.gopay.sdk.constants.GopayConstants;
import jp.gopay.sdk.models.common.ChargeId;
import jp.gopay.sdk.models.common.IdempotencyKey;
import jp.gopay.sdk.models.common.RefundId;
import jp.gopay.sdk.models.common.StoreId;
import jp.gopay.sdk.models.request.refund.RefundCreateData;
import jp.gopay.sdk.models.response.PaginatedList;
import jp.gopay.sdk.models.response.refund.Refund;
import jp.gopay.sdk.types.CursorDirection;
import retrofit2.Call;
import retrofit2.http.*;

import javax.annotation.Nullable;

/**
 * Resource for managing refunds.
 */
public interface RefundsResource{

    @GET("/stores/{storeId}/charges/{chargeId}/refunds")
    Call<PaginatedList<Refund>> list(
            @Path("storeId") StoreId storeId,
            @Path("chargeId") ChargeId chargeId,
            @Query("limit") @Nullable Integer limit,
            @Query("cursor_direction") @Nullable CursorDirection cursorDirection,
            @Query("cursor") @Nullable RefundId cursor,
            @Query("metadata") @Nullable String metadataSearch
    );

    @GET("/stores/{storeId}/charges/{chargeId}/refunds/{refundId}")
    Call<Refund> get(
            @Path("storeId") StoreId storeId,
            @Path("chargeId") ChargeId chargeId,
            @Path("refundId") RefundId refundId,
            @Query("polling") @Nullable Boolean polling
    );

    @POST("/stores/{storeId}/charges/{chargeId}/refunds")
    Call<Refund> create(
            @Path("storeId") StoreId storeId,
            @Path("chargeId") ChargeId chargeId,
            @Body RefundCreateData dataToPost,
            @Header(GopayConstants.idempotencyKeyHeaderName) IdempotencyKey idempotencyKey
    );

}
