package jp.gopay.sdk.resources;

import jp.gopay.sdk.constants.GopayConstants;
import jp.gopay.sdk.models.common.*;
import jp.gopay.sdk.models.common.Void;
import jp.gopay.sdk.models.request.store.CustomerIdRequest;
import jp.gopay.sdk.models.request.store.StoreCreateData;
import jp.gopay.sdk.models.response.PaginatedList;
import jp.gopay.sdk.models.response.store.CheckoutInfo;
import jp.gopay.sdk.models.response.store.Store;
import jp.gopay.sdk.models.response.store.StoreWithConfiguration;
import jp.gopay.sdk.types.CursorDirection;
import retrofit2.Call;
import retrofit2.http.*;

import javax.annotation.Nullable;

public interface StoresResource{

    @GET("/stores")
    Call<PaginatedList<Store>> list(
            @Query("limit") @Nullable Integer limit,
            @Query("cursor_direction") @Nullable CursorDirection cursorDirection,
            @Query("cursor") @Nullable StoreId cursor,
            @Query("search") @Nullable String search
    );

    @POST("/stores")
    Call<StoreWithConfiguration> create(
            @Body StoreCreateData dataToPost,
            @Header(GopayConstants.idempotencyKeyHeaderName) IdempotencyKey idempotencyKey
    );

    @GET("/stores/{storeId}")
    Call<StoreWithConfiguration> get(
            @Path("storeId") StoreId storeId
    );

    @PATCH("/stores/{storeId}")
    Call<StoreWithConfiguration> update(
            @Path("storeId") StoreId storeId,
            @Body StoreCreateData dataToPost,
            @Header(GopayConstants.idempotencyKeyHeaderName) IdempotencyKey idempotencyKey
    );

    @DELETE("/stores/{storeId}")
    Call<Void> delete(
            @Path("storeId") StoreId storeId
    );

    @GET("/checkout_info")
    Call<CheckoutInfo> getCheckoutInfo(
            @Query("origin") Domain origin
    );

    @POST("/stores/{storeId}/create_customer_id")
    Call<GopayCustomerId> createCustomerId(
            @Path("storeId") StoreId storeId,
            @Body CustomerIdRequest userId
    );
}
