package jp.gopay.sdk.resources;

import jp.gopay.sdk.constants.GopayConstants;
import jp.gopay.sdk.models.common.*;
import jp.gopay.sdk.models.common.Void;
import jp.gopay.sdk.models.request.transactiontoken.CreateReq;
import jp.gopay.sdk.models.request.transactiontoken.TemporaryTokenAliasReq;
import jp.gopay.sdk.models.request.transactiontoken.UpdateReq;
import jp.gopay.sdk.models.response.GoPayBinaryData;
import jp.gopay.sdk.models.response.PaginatedList;
import jp.gopay.sdk.models.response.transactiontoken.TemporaryTokenAlias;
import jp.gopay.sdk.models.response.transactiontoken.TransactionToken;
import jp.gopay.sdk.models.response.transactiontoken.TransactionTokenWithData;
import jp.gopay.sdk.types.CursorDirection;
import jp.gopay.sdk.types.ProcessingMode;
import jp.gopay.sdk.types.TransactionTokenType;
import retrofit2.Call;
import retrofit2.http.*;

import javax.annotation.Nullable;

public interface TransactionTokensResource{

    @POST("/tokens")
    Call<TransactionTokenWithData> create(
            @Body CreateReq dataToPost,
            @Header(GopayConstants.idempotencyKeyHeaderName) IdempotencyKey idempotencyKey
    );

    @GET("/stores/{storeId}/tokens/{tokenId}")
    Call<TransactionTokenWithData> get(
            @Path("storeId") StoreId storeId,
            @Path("tokenId") TransactionTokenId tokenId
    );

    @DELETE("/stores/{storeId}/tokens/{tokenId}")
    Call<Void> delete(
            @Path("storeId") StoreId storeId,
            @Path("tokenId") TransactionTokenId tokenId
    );

    @PATCH("/stores/{storeId}/tokens/{tokenId}")
    Call<TransactionTokenWithData> update(
            @Path("storeId") StoreId storeId,
            @Path("tokenId") TransactionTokenId tokenId,
            @Body UpdateReq dataToPatch,
            @Header(GopayConstants.idempotencyKeyHeaderName) IdempotencyKey idempotencyKey
    );

    @GET("/stores/{storeId}/tokens")
    Call<PaginatedList<TransactionToken>> list(
            @Path("storeId") StoreId storeId,
            @Query("limit") @Nullable Integer limit,
            @Query("cursor_direction") @Nullable CursorDirection cursorDirection,
            @Query("cursor") @Nullable TransactionTokenId cursor,
            @Query("all") @Nullable Boolean all,
            @Query("search") @Nullable String search,
            @Query("mode") @Nullable ProcessingMode mode,
            @Query("type") @Nullable TransactionTokenType type,
            @Query("customer_id") @Nullable GopayCustomerId customerId
    );

    @GET("/tokens")
    Call<PaginatedList<TransactionToken>> listMerchant(
            @Query("limit") @Nullable Integer limit,
            @Query("cursor_direction") @Nullable CursorDirection cursorDirection,
            @Query("cursor") @Nullable TransactionTokenId cursor,
            @Query("all") @Nullable Boolean all,
            @Query("search") @Nullable String search,
            @Query("mode") @Nullable ProcessingMode mode,
            @Query("type") @Nullable TransactionTokenType type,
            @Query("customer_id") @Nullable GopayCustomerId customerId
    );

    @POST("/tokens/alias")
    Call<TemporaryTokenAlias> createAlias(
            @Body TemporaryTokenAliasReq dataToPost,
            @Header(GopayConstants.idempotencyKeyHeaderName) IdempotencyKey idempotencyKey
    );


    @GET("/stores/{storeId}/tokens/alias/{aliasId}")
    Call<TemporaryTokenAlias> getAlias(
            @Path("storeId") StoreId storeId,
            @Path("aliasId") TemporaryTokenAliasId aliasId
    );

    @GET("/stores/{storeId}/tokens/alias/{aliasId}")
    Call<GoPayBinaryData> getAliasAsImage(
            @Path("storeId") StoreId storeId,
            @Path("aliasId") TemporaryTokenAliasId aliasId,
            @Query("media") @Nullable String media
    );

    @DELETE("/stores/{storeId}/tokens/alias/{aliasId}")
    Call<Void> deleteAlias(
            @Path("storeId") StoreId storeId,
            @Path("aliasId") TemporaryTokenAliasId aliasId
    );

}
